DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.09275949882143E-11   0.00000000000000E+00  -1.13598892691677E-13   1.47974947806486E-22
      1.09276431119067E-08   1.09275295130142E-08  -7.99416023833534E-19  -2.46304709481801E-01  -2.46304709481827E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57730110060826E-11   0.00000000000000E+00   2.57730110060826E-11
      3.71361512117044E-18  -2.46304709481801E-01  -2.42853835801530E-01   0.00000000000000E+00   1.25917337883317E-13
     -9.82500733650052E-23  -1.09534284413581E-08  -1.09533025240203E-08  -2.91419909733691E-18
      1.17500000000000E-09
      0.00000000000000E+00  -9.88047313931131E-12   0.00000000000000E+00  -7.70444282993374E-14   1.35419981016693E-22
      9.88050970492237E-09   9.88043266049421E-09  -8.08679659960902E-19  -2.42051569355066E-01  -2.42051569355093E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71332099231767E-11   0.00000000000000E+00   2.71332099231767E-11
      3.73193003786859E-18  -2.42051569355066E-01  -2.38930159062339E-01   0.00000000000000E+00   1.06144963128327E-13
     -9.81120347928362E-23  -9.90767201538041E-09  -9.90756587041738E-09  -2.92325037790768E-18
      2.08625000000000E-09
      0.00000000000000E+00  -8.88974395905372E-12   0.00000000000000E+00   4.41320559955297E-13   1.26249044426345E-22
      8.88982426944094E-09   8.89026559000102E-09  -8.18666931020376E-19  -2.37256267338104E-01  -2.37256267338131E-01
      0.00000000000000E+00   0.00000000000000E+00   2.66401452555939E-11   0.00000000000000E+00   2.66401452555939E-11
      3.75620587023274E-18  -2.37256267338109E-01  -2.34447122388655E-01   0.00000000000000E+00  -4.05059176959289E-13
     -9.79152091674103E-23  -8.91650067607955E-09  -8.91690573525661E-09  -2.93753893921237E-18
      3.31643750000000E-09
      0.00000000000000E+00  -7.97340901593423E-12   0.00000000000000E+00   5.00266739798395E-13   1.20341416393283E-22
      7.97342706507600E-09   7.97392733181592E-09  -8.29223136726350E-19  -2.31974899935373E-01  -2.31974899935398E-01
      0.00000000000000E+00   0.00000000000000E+00   2.45542838254131E-11   0.00000000000000E+00   2.45542838254131E-11
      3.78641224326622E-18  -2.31974899935381E-01  -2.29455119572069E-01   0.00000000000000E+00  -4.61883776882714E-13
     -9.76578583502005E-23  -7.99801973186435E-09  -7.99848161564134E-09  -2.95718910653987E-18
      4.97719062500000E-09
      0.00000000000000E+00  -7.14230598894332E-12   0.00000000000000E+00  -2.49511033664757E-14   1.17290148343943E-22
      7.14231600744081E-09   7.14229105633756E-09  -8.40153686401764E-19  -2.26319232763856E-01  -2.26319232763877E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12451343441655E-11   0.00000000000000E+00   2.12451343441655E-11
      3.82169516651934E-18  -2.26319232763859E-01  -2.24062334577661E-01   0.00000000000000E+00   6.15801361587277E-14
     -9.73477249675569E-23  -7.16359777081778E-09  -7.16353619068172E-09  -2.98154148011757E-18
      7.21920734375000E-09
      0.00000000000000E+00  -6.40304769915994E-12   0.00000000000000E+00  -1.64646070509890E-14   1.16465683246998E-22
      6.40312369207908E-09   6.40310722747215E-09  -8.51180715035408E-19  -2.20472430859310E-01  -2.20472430859327E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72031219375896E-11   0.00000000000000E+00   1.72031219375896E-11
      3.86026485351811E-18  -2.20472430859288E-01  -2.18449687330206E-01   0.00000000000000E+00   4.69251564101364E-14
     -9.70041774279696E-23  -6.42035727456604E-09  -6.42031034940973E-09  -3.00908413848270E-18
      1.02459299140625E-08
      0.00000000000000E+00  -5.76233881240023E-12   0.00000000000000E+00  -1.05893897354878E-14   1.17123520906740E-22
      5.76239269270828E-09   5.76238210331866E-09  -8.61914758791048E-19  -2.14693458931843E-01  -2.14693458931856E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29705876848109E-11   0.00000000000000E+00   1.29705876848109E-11
      3.89952322401394E-18  -2.14693458931760E-01  -2.12873910579139E-01   0.00000000000000E+00   3.34141739766485E-14
     -9.66557934093702E-23  -5.77538610517735E-09  -5.77535269100346E-09  -3.03760846522290E-18
      1.43320053839844E-08
      0.00000000000000E+00  -5.22670030500593E-12   0.00000000000000E+00  -6.56829366925004E-15   1.18549438972016E-22
      5.22674035433001E-09   5.22673378603646E-09  -8.71856379050982E-19  -2.09300890690806E-01  -2.09300890690815E-01
      0.00000000000000E+00   0.00000000000000E+00   9.04462043577972E-12   0.00000000000000E+00   9.04462043577972E-12
      3.93648022571133E-18  -2.09300890690585E-01  -2.07651336410143E-01   0.00000000000000E+00   2.20094430045133E-14
     -9.63339682924621E-23  -5.23580041591515E-09  -5.23577840647224E-09  -3.06462384666035E-18
      1.93320053839844E-08
      0.00000000000000E+00  -4.82735938762761E-12   0.00000000000000E+00  -4.00831668501005E-15   1.20059619445064E-22
      4.82733869467008E-09   4.82733468635352E-09  -8.79920421743959E-19  -2.04918302156295E-01  -2.04918302156301E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97971234159505E-12   0.00000000000000E+00   5.97971234159505E-12
      3.96637878741931E-18  -2.04918302155823E-01  -2.03395545165646E-01   0.00000000000000E+00   1.37876125474153E-14
     -9.60808874625322E-23  -4.83332818630757E-09  -4.83331439869511E-09  -3.08645836567535E-18
      2.43320053839844E-08
      0.00000000000000E+00  -4.57294946556276E-12   0.00000000000000E+00   1.49059971710023E-13   1.21194403225788E-22
      4.57300094183818E-09   4.57315000181001E-09  -8.85376491537993E-19  -2.01955532777229E-01  -2.01955532777233E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00404024005052E-12   0.00000000000000E+00   4.00404024005052E-12
      3.98639898861956E-18  -2.01955532772853E-01  -2.00513527517790E-01   0.00000000000000E+00  -1.43418475123464E-13
     -9.59157946878258E-23  -4.57701062357484E-09  -4.57715404205006E-09  -3.10102249708157E-18
      2.93320053839844E-08
      0.00000000000000E+00  -4.40579204384506E-12   0.00000000000000E+00   6.20686880938591E-14   1.22002956625874E-22
      4.40579465343073E-09   4.40585672211895E-09  -8.89112976551894E-19  -1.99930064367409E-01  -1.99930064367412E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71006168278515E-12   0.00000000000000E+00   2.71006168278515E-12
      3.99994929703349E-18  -1.99930064360422E-01  -1.98541145360319E-01   0.00000000000000E+00  -5.82138970083779E-14
     -9.58073856995135E-23  -4.40850856990463E-09  -4.40856678380173E-09  -3.11083632048160E-18
      3.43320053839844E-08
      0.00000000000000E+00  -4.29355777497746E-12   0.00000000000000E+00  -1.12886647243226E-15   1.22565599972712E-22
      4.29354986253461E-09   4.29354873366826E-09  -8.91690044150477E-19  -1.98535543531987E-01  -1.98535543531989E-01
      0.00000000000000E+00   0.00000000000000E+00   1.84977695267142E-12   0.00000000000000E+00   1.84977695267142E-12
      4.00919818179685E-18  -1.98535543521517E-01  -1.97182258466289E-01   0.00000000000000E+00   3.85377308342701E-15
     -9.57349736101440E-23  -4.29540236439392E-09  -4.29539851062094E-09  -3.11750813764637E-18
      3.93320053839844E-08
      0.00000000000000E+00  -4.21714295362080E-12   0.00000000000000E+00   3.85782675969860E-14   1.22953876702248E-22
      4.21717923054926E-09   4.21721780881698E-09  -8.93474932850946E-19  -1.97571096216383E-01  -1.97571096216385E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27065692369466E-12   0.00000000000000E+00   1.27065692369466E-12
      4.01555146641532E-18  -1.97571096201343E-01  -1.96242054279049E-01   0.00000000000000E+00  -3.68814192194113E-14
     -9.56856968671664E-23  -4.21845158432137E-09  -4.21848846574068E-09  -3.12207653356437E-18
      4.43320053839844E-08
      0.00000000000000E+00  -4.16469960867530E-12   0.00000000000000E+00   2.21655001045089E-13   1.23221206497739E-22
      4.16474185418031E-09   4.16496350918147E-09  -8.94714001357708E-19  -1.96902274725523E-01  -1.96902274725524E-01
      0.00000000000000E+00   0.00000000000000E+00   8.76906391001094E-13   0.00000000000000E+00   8.76906391001094E-13
      4.01993599837033E-18  -1.96902274705896E-01  -1.95589877262764E-01   0.00000000000000E+00  -2.21180209863000E-13
     -9.56513769562030E-23  -4.16561923536251E-09  -4.16584041557247E-09  -3.12522199701262E-18
      4.93320053839844E-08
      0.00000000000000E+00  -4.12878831642716E-12   0.00000000000000E+00   8.39343642542634E-15   1.23407839238672E-22
      4.12871174631460E-09   4.12872013975115E-09  -8.95577269460956E-19  -1.96436874069563E-01  -1.96436874069563E-01
      0.00000000000000E+00   0.00000000000000E+00   6.07277716816143E-13   0.00000000000000E+00   6.07277716816143E-13
      4.02297238695441E-18  -1.96436874045860E-01  -1.95135912969747E-01   0.00000000000000E+00  -7.56867991157425E-15
     -9.56293012490659E-23  -4.12931984878796E-09  -4.12932741746796E-09  -3.12739511749345E-18
      5.43320053839844E-08
      0.00000000000000E+00  -4.10362285843230E-12   0.00000000000000E+00   4.99528377070074E-14   1.23535513004174E-22
      4.10366242212147E-09   4.10371237495930E-09  -8.96178460289255E-19  -1.96112917114507E-01  -1.96112917114508E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21718247442696E-13   0.00000000000000E+00   4.21718247442696E-13
      4.02508097819162E-18  -1.96112917088103E-01  -1.94819906295772E-01   0.00000000000000E+00  -4.95224102281411E-14
     -9.56132412123957E-23  -4.10408457079642E-09  -4.10413409320675E-09  -3.12890251790236E-18
      5.93320053839844E-08
      0.00000000000000E+00  -4.08626420310007E-12   0.00000000000000E+00  -1.74943770142478E-16   1.23624601456925E-22
      4.08630410371921E-09   4.08630392877556E-09  -8.96597884132637E-19  -1.95887045211835E-01  -1.95887045211835E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93325424982012E-13   0.00000000000000E+00   2.93325424982012E-13
      4.02654760531653E-18  -1.95887045185091E-01  -1.94599543630308E-01   0.00000000000000E+00   5.81679425347523E-16
     -9.56024608458658E-23  -4.08659783587988E-09  -4.08659725420055E-09  -3.12994972118389E-18
      6.43320053839844E-08
      0.00000000000000E+00  -4.07423254252589E-12   0.00000000000000E+00   1.16296683041808E-14   1.23686195853597E-22
      4.07420549839261E-09   4.07421712806104E-09  -8.96890420836140E-19  -1.95729541207719E-01  -1.95729541207719E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04308825372931E-13   0.00000000000000E+00   2.04308825372931E-13
      4.02756914944339E-18  -1.95729541184238E-01  -1.94445879359355E-01   0.00000000000000E+00  -1.13820210305411E-14
     -9.55947693496848E-23  -4.07441005486529E-09  -4.07442143688641E-09  -3.13067872860725E-18
      6.93320053839844E-08
      0.00000000000000E+00  -4.06578282670279E-12   0.00000000000000E+00   3.95178017447399E-16   1.23729190942410E-22
      4.06578772639151E-09   4.06578812156965E-09  -8.97094639647625E-19  -1.95619621895553E-01  -1.95619621895553E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42412419393264E-13   0.00000000000000E+00   1.42412419393264E-13
      4.02828121154036E-18  -1.95619621879919E-01  -1.94338631594511E-01   0.00000000000000E+00  -2.00261844550291E-16
     -9.55895067452414E-23  -4.06593033372711E-09  -4.06593053398905E-09  -3.13118657189274E-18
      7.43320053839844E-08
      0.00000000000000E+00  -4.05990476352151E-12   0.00000000000000E+00   2.71609665859232E-15   1.23759074905945E-22
      4.05991435619414E-09   4.05991707229092E-09  -8.97237188404775E-19  -1.95542905127023E-01  -1.95542905127023E-01
      0.00000000000000E+00   0.00000000000000E+00   9.93378649932266E-14   0.00000000000000E+00   9.93378649932266E-14
      4.02877790086533E-18  -1.95542905124605E-01  -1.94263778825870E-01   0.00000000000000E+00  -2.58737227657560E-15
     -9.55857949833756E-23  -4.06001382278354E-09  -4.06001641015591E-09  -3.13154071246055E-18
      7.93320053839844E-08
      0.00000000000000E+00  -4.05586359508438E-12   0.00000000000000E+00   7.23565687366049E-17   1.23779936451829E-22
      4.05581941270640E-09   4.05581948506309E-09  -8.97336731412430E-19  -1.95489341189711E-01  -1.95489341189711E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93173109793546E-14   0.00000000000000E+00   6.93173109793546E-14
      4.02912448742023E-18  -1.95489341206348E-01  -1.94211514486408E-01   0.00000000000000E+00   2.25929315821626E-17
     -9.55832265645309E-23  -4.05588882496691E-09  -4.05588880237407E-09  -3.13178775600779E-18
      8.43320053839844E-08
      0.00000000000000E+00  -4.05292456349374E-12   0.00000000000000E+00   6.29199989366795E-16   1.23794473042988E-22
      4.05296060063349E-09   4.05296122983360E-09  -8.97406239374512E-19  -1.95451941238152E-01  -1.95451941238152E-01
      0.00000000000000E+00   0.00000000000000E+00   4.83858737638585E-14   0.00000000000000E+00   4.83858737638585E-14
      4.02936641678904E-18  -1.95451941279724E-01  -1.94175021828427E-01   0.00000000000000E+00  -5.64617618233504E-16
     -9.55814240811516E-23  -4.05300905108965E-09  -4.05300961570736E-09  -3.13196017741453E-18
      8.93320053839844E-08
      0.00000000000000E+00  -4.05099582401238E-12   0.00000000000000E+00   6.85402493354280E-18   1.23804623632053E-22
      4.05096551258354E-09   4.05096551943768E-09  -8.97454784520359E-19  -1.95425822611393E-01  -1.95425822611393E-01
      0.00000000000000E+00   0.00000000000000E+00   3.37810404938282E-14   0.00000000000000E+00   3.37810404938282E-14
      4.02953532199151E-18  -1.95425822682796E-01  -1.94149536389371E-01   0.00000000000000E+00   3.94349974976716E-17
     -9.55801707606620E-23  -4.05099933991308E-09  -4.05099930047818E-09  -3.13208053747115E-18
      9.43320053839844E-08
      0.00000000000000E+00  -4.04952630821706E-12   0.00000000000000E+00   1.42321975592099E-16   1.23811705432600E-22
      4.04957229216564E-09   4.04957243448774E-09  -8.97488688088358E-19  -1.95407582077844E-01  -1.95407582077844E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35885292236342E-14   0.00000000000000E+00   2.35885292236342E-14
      4.02965326463763E-18  -1.95407582181983E-01  -1.94131738036507E-01   0.00000000000000E+00  -1.10398487834762E-16
     -9.55792933082511E-23  -4.04959591261838E-09  -4.04959602301696E-09  -3.13216457654927E-18
      9.93320053839844E-08
      0.00000000000000E+00  -4.04860786084499E-12   0.00000000000000E+00   1.27918128128026E-16   1.23816653706921E-22
      4.04859951176779E-09   4.04859963968604E-09  -8.97512367994283E-19  -1.95394842399263E-01  -1.95394842399263E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64727558128644E-14   0.00000000000000E+00   1.64727558128644E-14
      4.02973562841669E-18  -1.95394842536090E-01  -1.94119307108863E-01   0.00000000000000E+00  -1.06042992586541E-16
     -9.55786817817312E-23  -4.04861600639877E-09  -4.04861611244186E-09  -3.13222326042241E-18
      1.04332005383984E-07
      0.00000000000000E+00  -4.04796494768453E-12   0.00000000000000E+00   3.02747621490057E-17   1.23820104505120E-22
      4.04792017748812E-09   4.04792020776301E-09  -8.97528907725267E-19  -1.95385944295349E-01  -1.95385944295349E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15044746169485E-14   0.00000000000000E+00   1.15044746169485E-14
      4.02979315078978E-18  -1.95385944460452E-01  -1.94110624624153E-01   0.00000000000000E+00  -1.48203557205406E-17
     -9.55782541117837E-23  -4.04793169741717E-09  -4.04793171223763E-09  -3.13226424306452E-18
      1.09332005383984E-07
      0.00000000000000E+00  -4.04750572399850E-12   0.00000000000000E+00   2.79816715190116E-17   1.23822516227971E-22
      4.04744571127082E-09   4.04744573925261E-09  -8.97540460354312E-19  -1.95379729266336E-01  -1.95379729266336E-01
      0.00000000000000E+00   0.00000000000000E+00   8.03500103340862E-15   0.00000000000000E+00   8.03500103340862E-15
      4.02983332579495E-18  -1.95379729449868E-01  -1.94104560188088E-01   0.00000000000000E+00  -1.71330284128204E-17
     -9.55779557276914E-23  -4.04745375712053E-09  -4.04745377425365E-09  -3.13229286544064E-18
      1.14332005383984E-07
      0.00000000000000E+00  -4.04713834504967E-12   0.00000000000000E+00   1.86444586131306E-16   1.23824203014466E-22
      4.04711428412724E-09   4.04711447057195E-09  -8.97548529131457E-19  -1.95375388419859E-01  -1.95375388419859E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61206065820527E-15   0.00000000000000E+00   5.61206065820527E-15
      4.02986138609824E-18  -1.95375388605408E-01  -1.94100324523760E-01   0.00000000000000E+00  -1.79799662088222E-16
     -9.55777472069794E-23  -4.04711990283285E-09  -4.04712008263261E-09  -3.13231285696678E-18
      1.19332005383984E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   5.38472193121340E-18   1.23825376665285E-22
      4.04688289561367E-09   4.04688290099852E-09  -8.97554165725237E-19  -1.95372356157739E-01  -1.95372356157739E-01
      0.00000000000000E+00   0.00000000000000E+00   3.91979432545289E-15   0.00000000000000E+00   3.91979432545289E-15
      4.02988098506986E-18  -1.95372356321843E-01  -1.94097365672839E-01   0.00000000000000E+00  -3.51674251558830E-19
     -9.55776015844717E-23  -4.04688682044107E-09  -4.04688682079284E-09  -3.13232681934463E-18
      1.24332005383984E-07
      0.00000000000000E+00  -4.04667912136363E-12   0.00000000000000E+00   4.35424302771179E-17   1.23826198311862E-22
      4.04672121302603E-09   4.04672125656858E-09  -8.97558102669476E-19  -1.95370238228657E-01  -1.95370238228657E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73786519741257E-15   0.00000000000000E+00   2.73786519741257E-15
      4.02989467439585E-18  -1.95370238341078E-01  -1.94095299002769E-01   0.00000000000000E+00  -4.00398874885465E-17
     -9.55774998635215E-23  -4.04672395439379E-09  -4.04672399443378E-09  -3.13233657172638E-18
      1.29332005383984E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   7.01132839108781E-19   1.23826771384583E-22
      4.04660830841743E-09   4.04660830911869E-09  -8.97560852690527E-19  -1.95368758836556E-01  -1.95368758836556E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91233920734041E-15   0.00000000000000E+00   1.91233920734041E-15
      4.02990423609189E-18  -1.95368758861367E-01  -1.94093855353978E-01   0.00000000000000E+00   1.84199497135092E-18
     -9.55774288117660E-23  -4.04661022329979E-09  -4.04661022145789E-09  -3.13234338340136E-18
      1.34332005383984E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   9.95332601679859E-18   1.23827172191098E-22
      4.04652943281175E-09   4.04652944276520E-09  -8.97562773479141E-19  -1.95367725529965E-01  -1.95367725529965E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33570791064939E-15   0.00000000000000E+00   1.33570791064939E-15
      4.02991091463144E-18  -1.95367725427924E-01  -1.94092846952099E-01   0.00000000000000E+00  -8.18395690880435E-18
     -9.55773791760735E-23  -4.04653077028906E-09  -4.04653077847311E-09  -3.13234814115230E-18
      1.39332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.22175169995221E-19   1.23827451980108E-22
      4.04647434725409E-09   4.04647434713204E-09  -8.97564115115900E-19  -1.95367003787280E-01  -1.95367003787280E-01
      0.00000000000000E+00   0.00000000000000E+00   9.32929603279146E-16   0.00000000000000E+00   9.32929603279146E-16
      4.02991557927946E-18  -1.95367003519563E-01  -1.94092142525453E-01   0.00000000000000E+00   1.37871361787389E-18
     -9.55773444993355E-23  -4.04647528144026E-09  -4.04647528006164E-09  -3.13235146416356E-18
      1.44332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   2.17146686131850E-18   1.23827647538547E-22
      4.04643586847089E-09   4.04643587064248E-09  -8.97565052183764E-19  -1.95366499685116E-01  -1.95366499685116E-01
      0.00000000000000E+00   0.00000000000000E+00   6.51587203794342E-16   0.00000000000000E+00   6.51587203794342E-16
      4.02991883721548E-18  -1.95366499218607E-01  -1.94091650435944E-01   0.00000000000000E+00  -1.29069423907128E-18
     -9.55773202703404E-23  -4.04643652093890E-09  -4.04643652222969E-09  -3.13235378503171E-18
      1.49332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.68576093974830E-19   1.23827784083674E-22
      4.04640899394167E-09   4.04640899377321E-09  -8.97565706688334E-19  -1.95366147592629E-01  -1.95366147592629E-01
      0.00000000000000E+00   0.00000000000000E+00   4.55075644876879E-16   0.00000000000000E+00   4.55075644876879E-16
      4.02992111259370E-18  -1.95366146906633E-01  -1.94091306652755E-01   0.00000000000000E+00   7.87687758187823E-19
     -9.55773033390791E-23  -4.04640944963645E-09  -4.04640944884886E-09  -3.13235540590537E-18
      1.54332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   4.24761444875271E-19   1.23827879463345E-22
      4.04639022145306E-09   4.04639022187795E-09  -8.97566163839611E-19  -1.95365901669497E-01  -1.95365901669497E-01
      0.00000000000000E+00   0.00000000000000E+00   3.17829368032984E-16   0.00000000000000E+00   3.17829368032984E-16
      4.02992270174054E-18  -1.95365900763605E-01  -1.94091066467273E-01   0.00000000000000E+00   1.23109717505364E-20
     -9.55772915065492E-23  -4.04639053971953E-09  -4.04639053970732E-09  -3.13235653790093E-18
      1.59332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.09316454645296E-19   1.23827946030370E-22
      4.04637710796779E-09   4.04637710785860E-09  -8.97566483181057E-19  -1.95365729884480E-01  -1.95365729884480E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21992844964814E-16   0.00000000000000E+00   2.21992844964814E-16
      4.02992381170477E-18  -1.95365728787015E-01  -1.94090898652308E-01   0.00000000000000E+00   4.12295934446443E-19
     -9.55772832375980E-23  -4.04637733026365E-09  -4.04637732985145E-09  -3.13235732852371E-18
      1.64332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   5.00755611317684E-20   1.23827992467327E-22
      4.04636794466852E-09   4.04636794471872E-09  -8.97566706313674E-19  -1.95365609857572E-01  -1.95365609857572E-01
      0.00000000000000E+00   0.00000000000000E+00   1.55096201815023E-16   0.00000000000000E+00   1.55096201815023E-16
      4.02992458718578E-18  -1.95365608633761E-01  -1.94090781407046E-01   0.00000000000000E+00   1.59625652654600E-19
     -9.55772774617495E-23  -4.04636809997445E-09  -4.04636809981492E-09  -3.13235788087210E-18
      1.69332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.88115686054926E-20   1.23828024814039E-22
      4.04636153847718E-09   4.04636153841850E-09  -8.97566862310218E-19  -1.95365525948437E-01  -1.95365525948437E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08428344444087E-16   0.00000000000000E+00   1.08428344444087E-16
      4.02992512932750E-18  -1.95365524707099E-01  -1.94090699513369E-01   0.00000000000000E+00   2.05154210367402E-19
     -9.55772734325121E-23  -4.04636164705190E-09  -4.04636164684684E-09  -3.13235826701728E-18
      1.74332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.11071245909448E-20   1.23828047305200E-22
      4.04635705530010E-09   4.04635705528912E-09  -8.97566971487104E-19  -1.95365467226789E-01  -1.95365467226789E-01
      0.00000000000000E+00   0.00000000000000E+00   7.59034146007041E-17   0.00000000000000E+00   7.59034146007041E-17
      4.02992550884457E-18  -1.95365466124054E-01  -1.94090642353005E-01   0.00000000000000E+00   1.13643080422438E-19
     -9.55772706301942E-23  -4.04635713130608E-09  -4.04635713119253E-09  -3.13235853735747E-18
      1.79332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.12890529887917E-20   1.23828062899845E-22
      4.04635391273909E-09   4.04635391270792E-09  -8.97567048038711E-19  -1.95365426055360E-01  -1.95365426055360E-01
      0.00000000000000E+00   0.00000000000000E+00   5.32655187363216E-17   0.00000000000000E+00   5.32655187363216E-17
      4.02992577517216E-18  -1.95365425293701E-01  -1.94090602519854E-01   0.00000000000000E+00   1.01004285499313E-19
     -9.55772686928349E-23  -4.04635396607435E-09  -4.04635396597344E-09  -3.13235872713345E-18
      1.84332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.34521804517671E-20   1.23828073678531E-22
      4.04635170419785E-09   4.04635170418452E-09  -8.97567101874351E-19  -1.95365397101650E-01  -1.95365397101651E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75350752368907E-17   0.00000000000000E+00   3.75350752368907E-17
      4.02992596284754E-18  -1.95365396922416E-01  -1.94090574849330E-01   0.00000000000000E+00   6.11739986372471E-20
     -9.55772673684058E-23  -4.04635174178068E-09  -4.04635174171960E-09  -3.13235886097319E-18
      1.89332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.62165024900848E-20   1.23828081108682E-22
      4.04635014652793E-09   4.04635014651184E-09  -8.97567139897856E-19  -1.95365376649608E-01  -1.95365376649608E-01
      0.00000000000000E+00   0.00000000000000E+00   2.66201774597421E-17   0.00000000000000E+00   2.66201774597421E-17
      4.02992609594843E-18  -1.95365377317347E-01  -1.94090555738447E-01   0.00000000000000E+00   4.76578080820456E-20
     -9.55772664805713E-23  -4.04635017317958E-09  -4.04635017313202E-09  -3.13235895605057E-18
      1.94332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -9.09400683793243E-21   1.23828086235400E-22
      4.04634904322499E-09   4.04634904321602E-09  -8.97567166899487E-19  -1.95365362119963E-01  -1.95365362119963E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90463936268322E-17   0.00000000000000E+00   1.90463936268322E-17
      4.02992619118040E-18  -1.95365363897203E-01  -1.94090542668288E-01   0.00000000000000E+00   2.99160362701235E-20
     -9.55772659048396E-23  -4.04634906229224E-09  -4.04634906226242E-09  -3.13235902428091E-18
      1.99332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -6.01329200263888E-21   1.23828089811497E-22
      4.04634825895724E-09   4.04634825895135E-09  -8.97567186176471E-19  -1.95365351736576E-01  -1.95365351736576E-01
      0.00000000000000E+00   0.00000000000000E+00   1.37676767938991E-17   0.00000000000000E+00   1.37676767938991E-17
      4.02992626001878E-18  -1.95365354848446E-01  -1.94090533868279E-01   0.00000000000000E+00   2.09797686156545E-20
     -9.55772655512944E-23  -4.04634827273991E-09  -4.04634827271902E-09  -3.13235907384231E-18
      2.04332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -4.42904194263708E-21   1.23828092387699E-22
      4.04634770165766E-09   4.04634770165336E-09  -8.97567199966640E-19  -1.95365344293479E-01  -1.95365344293479E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00359269030492E-17   0.00000000000000E+00   1.00359269030492E-17
      4.02992631019842E-18  -1.95365348882602E-01  -1.94090528079190E-01   0.00000000000000E+00   1.23612654032348E-20
     -9.55772653525039E-23  -4.04634771170155E-09  -4.04634771168928E-09  -3.13235911023177E-18
      2.09332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -4.06326992301184E-21   1.23828094372822E-22
      4.04634730997121E-09   4.04634730996727E-09  -8.97567209752572E-19  -1.95365338991616E-01  -1.95365338991616E-01
      0.00000000000000E+00   0.00000000000000E+00   7.31113010726574E-18   0.00000000000000E+00   7.31113010726574E-18
      4.02992634675407E-18  -1.95365345065208E-01  -1.94090524386056E-01   0.00000000000000E+00   6.26567469618029E-21
     -9.55772652548181E-23  -4.04634731728457E-09  -4.04634731727840E-09  -3.13235913700149E-18
      2.14332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.82520237792993E-21   1.23828096072399E-22
      4.04634704428093E-09   4.04634704427923E-09  -8.97567216478719E-19  -1.95365335322509E-01  -1.95365335322509E-01
      0.00000000000000E+00   0.00000000000000E+00   5.20123582184015E-18   0.00000000000000E+00   5.20123582184015E-18
      4.02992637276024E-18  -1.95365342695401E-01  -1.94090522100620E-01   0.00000000000000E+00   3.09305964095590E-21
     -9.55772652124681E-23  -4.04634704948347E-09  -4.04634704948047E-09  -3.13235915628152E-18
      2.19332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -9.49635605952019E-22   1.23828097711362E-22
      4.04634688014855E-09   4.04634688014772E-09  -8.97567220710413E-19  -1.95365332983210E-01  -1.95365332983210E-01
      0.00000000000000E+00   0.00000000000000E+00   3.42293975764638E-18   0.00000000000000E+00   3.42293975764638E-18
      4.02992638987494E-18  -1.95365341222626E-01  -1.94090520680115E-01   0.00000000000000E+00  -1.76027784444645E-22
     -9.55772651837422E-23  -4.04634688357039E-09  -4.04634688357066E-09  -3.13235916916453E-18
      2.24332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.08588568326242E-21   1.23828099444793E-22
      4.04634680328096E-09   4.04634680328000E-09  -8.97567222756206E-19  -1.95365331810988E-01  -1.95365331810988E-01
      0.00000000000000E+00   0.00000000000000E+00   1.77795209994497E-18   0.00000000000000E+00   1.77795209994497E-18
      4.02992639876470E-18  -1.95365340191060E-01  -1.94090519673285E-01   0.00000000000000E+00   4.49122318597337E-21
     -9.55772651290422E-23  -4.04634680506234E-09  -4.04634680505795E-09  -3.13235917600850E-18
      2.29332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   7.85038197120663E-22   1.23828101360172E-22
      4.04634680547493E-09   4.04634680547584E-09  -8.97567222767877E-19  -1.95365331729963E-01  -1.95365331729963E-01
      0.00000000000000E+00   0.00000000000000E+00   1.40077850177465E-19   0.00000000000000E+00   1.40077850177465E-19
      4.02992639946509E-18  -1.95365339205994E-01  -1.94090518688043E-01   0.00000000000000E+00   3.65680576620330E-21
     -9.55772650105782E-23  -4.04634680561948E-09  -4.04634680561592E-09  -3.13235917669722E-18
      2.34332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   9.34090295117946E-22   1.23828103473840E-22
      4.04634688114251E-09   4.04634688114357E-09  -8.97567220828133E-19  -1.95365332704206E-01  -1.95365332704206E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55005366711578E-18   0.00000000000000E+00  -1.55005366711578E-18
      4.02992639171482E-18  -1.95365337918256E-01  -1.94090517376998E-01   0.00000000000000E+00   1.02365871842368E-20
     -9.55772647936435E-23  -4.04634687960366E-09  -4.04634687959352E-09  -3.13235917088669E-18
      2.39332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   2.93440602744346E-21   1.23828105724586E-22
      4.04634702416711E-09   4.04634702417017E-09  -8.97567217031569E-19  -1.95365334694212E-01  -1.95365334694212E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.28574672959132E-18   0.00000000000000E+00  -3.28574672959132E-18
      4.02992637528609E-18  -1.95365336024208E-01  -1.94090515438435E-01   0.00000000000000E+00   1.39290557223535E-20
     -9.55772644493456E-23  -4.04634702089825E-09  -4.04634702088442E-09  -3.13235915825452E-18
      2.44332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   1.68255129027609E-21   1.23828107967133E-22
      4.04634722505084E-09   4.04634722505264E-09  -8.97567211561356E-19  -1.95365337615320E-01  -1.95365337615320E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.99298334002608E-18   0.00000000000000E+00  -4.99298334002608E-18
      4.02992635032117E-18  -1.95365333279270E-01  -1.94090512630744E-01   0.00000000000000E+00   2.07292147822112E-20
     -9.55772639586264E-23  -4.04634722008030E-09  -4.04634722005966E-09  -3.13235913875982E-18
      2.49332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   3.81088722947043E-21   1.23828109968793E-22
      4.04634746833156E-09   4.04634746833549E-09  -8.97567204760485E-19  -1.95365341298582E-01  -1.95365341298582E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.53003465865825E-18   0.00000000000000E+00  -6.53003465865825E-18
      4.02992631767100E-18  -1.95365329522913E-01  -1.94090508798222E-01   0.00000000000000E+00   2.58573384973570E-20
     -9.55772633173470E-23  -4.04634746183122E-09  -4.04634746180546E-09  -3.13235911291051E-18
      2.54332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   3.08117205031808E-21   1.23828111412449E-22
      4.04634773049017E-09   4.04634773049337E-09  -8.97567197193870E-19  -1.95365345456013E-01  -1.95365345456013E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.69033820448938E-18   0.00000000000000E+00  -7.69033820448938E-18
      4.02992627921931E-18  -1.95365324712487E-01  -1.94090503905565E-01   0.00000000000000E+00   3.15583526382408E-20
     -9.55772625419129E-23  -4.04634772283450E-09  -4.04634772280303E-09  -3.13235908202544E-18
      2.59332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   1.88646919121715E-21   1.23828111907945E-22
      4.04634797843725E-09   4.04634797843926E-09  -8.97567189696259E-19  -1.95365349652919E-01  -1.95365349652919E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.21027032803740E-18   0.00000000000000E+00  -8.21027032803740E-18
      4.02992623816796E-18  -1.95365318962496E-01  -1.94090498077620E-01   0.00000000000000E+00   3.69818372592340E-20
     -9.55772616750115E-23  -4.04634797026587E-09  -4.04634797022899E-09  -3.13235904847170E-18
      2.64332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   2.49776567901583E-21   1.23828111035552E-22
      4.04634817000561E-09   4.04634817000823E-09  -8.97567183372040E-19  -1.95365353304709E-01  -1.95365353304710E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.80273794739052E-18   0.00000000000000E+00  -7.80273794739052E-18
      4.02992619915427E-18  -1.95365312579899E-01  -1.94090491634538E-01   0.00000000000000E+00   3.92674551668672E-20
     -9.55772607890403E-23  -4.04634816224466E-09  -4.04634816220549E-09  -3.13235901578223E-18
      2.69332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   6.08013683922539E-20   1.23828108363535E-22
      4.04634825428765E-09   4.04634825434858E-09  -8.97567179597167E-19  -1.95365355673572E-01  -1.95365355673572E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16022108226977E-18   0.00000000000000E+00  -6.16022108226977E-18
      4.02992616835316E-18  -1.95365306096139E-01  -1.94090485123705E-01   0.00000000000000E+00  -4.64635624379692E-20
     -9.55772599941623E-23  -4.04634824814180E-09  -4.04634824818836E-09  -3.13235898875599E-18
      2.74332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -9.00748803884032E-19   1.23828103644646E-22
      4.04634818329875E-09   4.04634818239813E-09  -8.97567179782762E-19  -1.95365355988609E-01  -1.95365355988609E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.14685510736692E-18   0.00000000000000E+00  -3.14685510736692E-18
      4.02992615261889E-18  -1.95365300243396E-01  -1.94090479292377E-01   0.00000000000000E+00   8.70237930866994E-19
     -9.55772594679359E-23  -4.04634818012142E-09  -4.04634817925128E-09  -3.13235897283613E-18
      2.76832005383985E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   2.86076755803862E-14   1.23827761084804E-22
      4.04636143589712E-09   4.04639004357282E-09  -8.97567967054960E-19  -1.95364975797737E-01  -1.95364975797737E-01
      0.00000000000000E+00   0.00000000000000E+00   6.75890537049158E-16   0.00000000000000E+00   6.75890537049158E-16
      4.02992784234523E-18  -1.95365263598726E-01  -1.94090438260017E-01   0.00000000000000E+00  -2.84271136292917E-14
     -9.56184093065168E-23  -4.04636229234963E-09  -4.04639071946336E-09  -3.13235987529027E-18
      2.77675755383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.06118032337044E-18   1.23827272085245E-22
      4.04630919909203E-09   4.04630919603098E-09  -8.97568034309947E-19  -1.95364933486075E-01  -1.95364933486075E-01
      0.00000000000000E+00   0.00000000000000E+00   6.10029317512154E-16   0.00000000000000E+00   6.10029317512154E-16
      4.02992835705747E-18  -1.95365294894267E-01  -1.94090486033316E-01   0.00000000000000E+00   1.69455501353014E-18
     -9.55772969834848E-23  -4.04630980775475E-09  -4.04630980606029E-09  -3.13236032274752E-18
      2.78814817883985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.03101165044819E-18   1.23827332382392E-22
      4.04630713056815E-09   4.04630712953726E-09  -8.97568117995488E-19  -1.95364885138011E-01  -1.95364885138011E-01
      0.00000000000000E+00   0.00000000000000E+00   5.05348178104667E-16   0.00000000000000E+00   5.05348178104667E-16
      4.02992893268062E-18  -1.95365339049181E-01  -1.94090530871967E-01   0.00000000000000E+00  -1.07642133225462E-20
     -9.55775417170350E-23  -4.04630763487458E-09  -4.04630763488544E-09  -3.13236081468514E-18
      2.80352552258985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -7.11467727523292E-20   1.23827403098822E-22
      4.04630495234719E-09   4.04630495227616E-09  -8.97568209579256E-19  -1.95364830469864E-01  -1.95364830469864E-01
      0.00000000000000E+00   0.00000000000000E+00   4.32419866089763E-16   0.00000000000000E+00   4.32419866089763E-16
      4.02992959762752E-18  -1.95365401091142E-01  -1.94090593623177E-01   0.00000000000000E+00  -1.02702976479955E-18
     -9.55773125320045E-23  -4.04630538366891E-09  -4.04630538469603E-09  -3.13236138804826E-18
      2.82428493665235E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.88367154318419E-20   1.23827496732629E-22
      4.04630258845461E-09   4.04630258839590E-09  -8.97568310286085E-19  -1.95364769179594E-01  -1.95364769179594E-01
      0.00000000000000E+00   0.00000000000000E+00   3.63552885020485E-16   0.00000000000000E+00   3.63552885020485E-16
      4.02993035234201E-18  -1.95365488003069E-01  -1.94090681301578E-01   0.00000000000000E+00  -1.09413658559512E-18
     -9.55773232432878E-23  -4.04630295085455E-09  -4.04630295194878E-09  -3.13236204205592E-18
      2.85231014563672E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -4.57740821809756E-20   1.23827598011130E-22
      4.04630010914703E-09   4.04630010910138E-09  -8.97568418637977E-19  -1.95364702229395E-01  -1.95364702229395E-01
      0.00000000000000E+00   0.00000000000000E+00   3.00344686533834E-16   0.00000000000000E+00   3.00344686533834E-16
      4.02993119406427E-18  -1.95365608961503E-01  -1.94090803061076E-01   0.00000000000000E+00  -1.14134998067332E-18
     -9.55773381380018E-23  -4.04630040830461E-09  -4.04630040944606E-09  -3.13236277542629E-18
      2.89014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.69669993618951E-20   1.23827710772279E-22
      4.04629812440682E-09   4.04629812437997E-09  -8.97568521111711E-19  -1.95364636470675E-01  -1.95364636470675E-01
      0.00000000000000E+00   0.00000000000000E+00   2.36411409501484E-16   0.00000000000000E+00   2.36411409501484E-16
      4.02993208850396E-18  -1.95365773660255E-01  -1.94090968405317E-01   0.00000000000000E+00  -1.12523406548863E-18
     -9.55773577659923E-23  -4.04629835966605E-09  -4.04629836079138E-09  -3.13236356739224E-18
      2.94014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   9.42685937579139E-21   1.23827861453636E-22
      4.04629882678494E-09   4.04629882679449E-09  -8.97568563648852E-19  -1.95364599904575E-01  -1.95364599904575E-01
      0.00000000000000E+00   0.00000000000000E+00   1.50080339540791E-16   0.00000000000000E+00   1.50080339540791E-16
      4.02993283890565E-18  -1.95365977986435E-01  -1.94091172537454E-01   0.00000000000000E+00  -9.73318429792704E-19
     -9.55773796606243E-23  -4.04629897590141E-09  -4.04629897687483E-09  -3.13236427525679E-18
      2.99014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   5.95865480720736E-20   1.23828042421754E-22
      4.04630411671009E-09   4.04630411676980E-09  -8.97568482352868E-19  -1.95364629651496E-01  -1.95364629651496E-01
      0.00000000000000E+00   0.00000000000000E+00   4.01763539100377E-17   0.00000000000000E+00   4.01763539100377E-17
      4.02993303978742E-18  -1.95366148062133E-01  -1.94091340981181E-01   0.00000000000000E+00  -6.59760823183995E-19
     -9.55773937542312E-23  -4.04630415628630E-09  -4.04630415694616E-09  -3.13236455743455E-18
      3.04014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   1.23952822010600E-19   1.23828270204555E-22
      4.04631535799617E-09   4.04631535812024E-09  -8.97568239695680E-19  -1.95364745969238E-01  -1.95364745969238E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05360402469672E-16   0.00000000000000E+00  -1.05360402469672E-16
      4.02993251298541E-18  -1.95366257572305E-01  -1.94091446995571E-01   0.00000000000000E+00  -1.72139627876029E-19
     -9.55773957606706E-23  -4.04631525258760E-09  -4.04631525275984E-09  -3.13236427328973E-18
      3.09014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   2.01484145365488E-19   1.23828550843700E-22
      4.04633379854150E-09   4.04633379874311E-09  -8.97567798395477E-19  -1.95364969633423E-01  -1.95364969633423E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91253235111983E-16   0.00000000000000E+00  -2.91253235111983E-16
      4.02993105671923E-18  -1.95366275579784E-01  -1.94091459251773E-01   0.00000000000000E+00   5.09736686044557E-19
     -9.55773810507898E-23  -4.04633350799951E-09  -4.04633350748987E-09  -3.13236325832376E-18
      3.14014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   4.34469034276125E-19   1.23828879510028E-22
      4.04636030054224E-09   4.04636030097683E-09  -8.97567129107535E-19  -1.95365317754601E-01  -1.95365317754601E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.14798304852317E-16   0.00000000000000E+00  -5.14798304852317E-16
      4.02992848272771E-18  -1.95366168536145E-01  -1.94091343928863E-01   0.00000000000000E+00   1.23533647276109E-18
     -9.55773450822706E-23  -4.04635978741377E-09  -4.04635978617853E-09  -3.13236135362017E-18
      3.19014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   4.01235903003025E-19   1.23829239107176E-22
      4.04639502392132E-09   4.04639502432268E-09  -8.97566219287819E-19  -1.95365798964291E-01  -1.95365798964291E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.64864179185738E-16   0.00000000000000E+00  -7.64864179185738E-16
      4.02992465840681E-18  -1.95365903685393E-01  -1.94091068216946E-01   0.00000000000000E+00   2.40779947863876E-18
     -9.55772840518888E-23  -4.04639426186621E-09  -4.04639425945850E-09  -3.13235843911899E-18
      3.24014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   7.77399048490790E-19   1.23829598822671E-22
      4.04643708434478E-09   4.04643708512230E-09  -8.97565082889510E-19  -1.95366408107087E-01  -1.95366408107087E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02077589328406E-15   0.00000000000000E+00  -1.02077589328406E-15
      4.02991955452734E-18  -1.95365453919050E-01  -1.94090605279643E-01   0.00000000000000E+00   3.23492843370277E-18
     -9.55771957381906E-23  -4.04643606758124E-09  -4.04643606434641E-09  -3.13235447163783E-18
      3.29014417776563E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   5.04940043222197E-19   1.23829913325774E-22
      4.04648422187311E-09   4.04648422237818E-09  -8.97563770126359E-19  -1.95367120821963E-01  -1.95367120821963E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25165337207705E-15   0.00000000000000E+00  -1.25165337207705E-15
      4.02991329626049E-18  -1.95364803956692E-01  -1.94089940538807E-01   0.00000000000000E+00   4.73284029454716E-18
     -9.55770804927265E-23  -4.04648297545755E-09  -4.04648297072481E-09  -3.13234952613412E-18
      3.34014417776563E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   6.31267640070214E-19   1.23830123334886E-22
      4.04653252154366E-09   4.04653252217505E-09  -8.97562376180643E-19  -1.95367888593366E-01  -1.95367888593366E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41659076468417E-15   0.00000000000000E+00  -1.41659076468417E-15
      4.02990621330666E-18  -1.95363957559134E-01  -1.94089078975814E-01   0.00000000000000E+00   5.59709190909796E-18
     -9.55769422905398E-23  -4.04653111118128E-09  -4.04653110558428E-09  -3.13234383712602E-18
      3.39014417776563E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   4.45324233388553E-19   1.23830158029022E-22
      4.04657624641907E-09   4.04657624686452E-09  -8.97561047362206E-19  -1.95368635070631E-01  -1.95368635070631E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46616477914588E-15   0.00000000000000E+00  -1.46616477914588E-15
      4.02989888248277E-18  -1.95362945185983E-01  -1.94088052842174E-01   0.00000000000000E+00   6.42621706495908E-18
     -9.55767897413494E-23  -4.04657478712586E-09  -4.04657478069974E-09  -3.13233783512056E-18
      3.44014417776563E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   4.08161796194629E-19   1.23829939934349E-22
      4.04660784342292E-09   4.04660784383121E-09  -8.97559982949322E-19  -1.95369254606983E-01  -1.95369254606983E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34555665276620E-15   0.00000000000000E+00  -1.34555665276620E-15
      4.02989215469950E-18  -1.95361831281175E-01  -1.94086928944228E-01   0.00000000000000E+00   6.42828504851503E-18
     -9.55766368889663E-23  -4.04660650470274E-09  -4.04660649827456E-09  -3.13233217175018E-18
      3.49014417776563E-07
      0.00000000000000E+00  -4.04667912136363E-12   0.00000000000000E+00   3.27389732745862E-19   1.23829392561489E-22
      4.04661819424336E-09   4.04661819457088E-09  -8.97559430746108E-19  -1.95369614097639E-01  -1.95369614097639E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99655591265775E-16   0.00000000000000E+00  -9.99655591265775E-16
      4.02988715642154E-18  -1.95360720042157E-01  -1.94085814334884E-01   0.00000000000000E+00   5.57820664250969E-18
     -9.55765036323043E-23  -4.04661720049340E-09  -4.04661719491529E-09  -3.13232772567544E-18
      3.54014417776563E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   2.00074048508330E-18   1.23828451056985E-22
      4.04659717645503E-09   4.04659717845589E-09  -8.97559674352151E-19  -1.95369559228468E-01  -1.95369559228468E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.80259781738053E-16   0.00000000000000E+00  -3.80259781738053E-16
      4.02988525512264E-18  -1.95359758302347E-01  -1.94084859021561E-01   0.00000000000000E+00   1.78739572476644E-18
     -9.55764155318532E-23  -4.04659679998341E-09  -4.04659679819611E-09  -3.13232558077048E-18
      3.59014417776563E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   4.06098842003943E-19   1.23827075577506E-22
      4.04653458938390E-09   4.04653458979013E-09  -8.97561010538874E-19  -1.95368926067808E-01  -1.95368926067808E-01
      0.00000000000000E+00   0.00000000000000E+00   5.44716237755756E-16   0.00000000000000E+00   5.44716237755756E-16
      4.02988797870382E-18  -1.95359133937421E-01  -1.94084254083677E-01   0.00000000000000E+00  -1.01671362220104E-19
     -9.55764027969830E-23  -4.04653513440460E-09  -4.04653513450637E-09  -3.13232696816495E-18
      3.64014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   7.58593062987768E-18   1.23825267093266E-22
      4.04642146666611E-09   4.04642147425216E-09  -8.97563715375558E-19  -1.95367558789380E-01  -1.95367558789380E-01
      0.00000000000000E+00   0.00000000000000E+00   1.78029448724542E-15   0.00000000000000E+00   1.78029448724542E-15
      4.02989688017626E-18  -1.95359068199497E-01  -1.94084223596739E-01   0.00000000000000E+00  -1.24112440347814E-17
     -9.55764982320866E-23  -4.04642324213531E-09  -4.04642325454665E-09  -3.13233316480070E-18
      3.69014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00   5.17828934763741E-19   1.23823083800122E-22
      4.04625178533967E-09   4.04625178585762E-09  -8.97567999377880E-19  -1.95365333531950E-01  -1.95365333531950E-01
      0.00000000000000E+00   0.00000000000000E+00   3.29261120703549E-15   0.00000000000000E+00   3.29261120703549E-15
      4.02991334323230E-18  -1.95359800397061E-01  -1.94085008777544E-01   0.00000000000000E+00  -1.16181501661435E-17
     -9.55767339921051E-23  -4.04625506685058E-09  -4.04625507846883E-09  -3.13234534385442E-18
      3.74014417776563E-07
      0.00000000000000E+00  -4.04603620820318E-12   0.00000000000000E+00   1.42211260516693E-17   1.23820657824487E-22
      4.04602445502174E-09   4.04602446924299E-09  -8.97573952321958E-19  -1.95362188077830E-01  -1.95362188077830E-01
      0.00000000000000E+00   0.00000000000000E+00   4.99731239669741E-15   0.00000000000000E+00   4.99731239669741E-15
      4.02993832979428E-18  -1.95361563952606E-01  -1.94086843418730E-01   0.00000000000000E+00  -3.35216965920376E-17
     -9.55771370818907E-23  -4.04602943303360E-09  -4.04602946655539E-09  -3.13236437747232E-18
      3.79014417776563E-07
      0.00000000000000E+00  -4.04576067399155E-12   0.00000000000000E+00  -5.15313337698768E-19   1.23818207327665E-22
      4.04574554589591E-09   4.04574554538072E-09  -8.97581481677276E-19  -1.95358155494000E-01  -1.95358155494000E-01
      0.00000000000000E+00   0.00000000000000E+00   6.74964314364863E-15   0.00000000000000E+00   6.74964314364863E-15
      4.02997207801000E-18  -1.95364553139392E-01  -1.94089919926771E-01   0.00000000000000E+00  -2.65318696519085E-17
     -9.55777236632596E-23  -4.04575226849190E-09  -4.04575229502386E-09  -3.13239059633272E-18
      3.84014417776563E-07
      0.00000000000000E+00  -4.04548513977993E-12   0.00000000000000E+00   1.09996438546230E-17   1.23816044943086E-22
      4.04543039497682E-09   4.04543040597659E-09  -8.97590248981351E-19  -1.95353399330746E-01  -1.95353399330746E-01
      0.00000000000000E+00   0.00000000000000E+00   8.33884776707800E-15   0.00000000000000E+00   8.33884776707800E-15
      4.03001377224884E-18  -1.95368881450727E-01  -1.94094347029297E-01   0.00000000000000E+00  -4.72531384942083E-17
     -9.55784924465616E-23  -4.04543869757112E-09  -4.04543874482435E-09  -3.13242352326749E-18
      3.89014417776563E-07
      0.00000000000000E+00  -4.04511776083110E-12   0.00000000000000E+00  -2.90444518410093E-18   1.23814573871941E-22
      4.04510548791963E-09   4.04510548501530E-09  -8.97599612823461E-19  -1.95348246055796E-01  -1.95348246055795E-01
      0.00000000000000E+00   0.00000000000000E+00   9.48809625838923E-15   0.00000000000000E+00   9.48809625838923E-15
      4.03006121273013E-18  -1.95374533096175E-01  -1.94100100678603E-01   0.00000000000000E+00  -3.92027624414012E-17
     -9.55794176266396E-23  -4.04511493390871E-09  -4.04511497311157E-09  -3.13246159990667E-18
      3.94014417776563E-07
      0.00000000000000E+00  -4.04484222661948E-12   0.00000000000000E+00  -2.38081922004115E-18   1.23814274270970E-22
      4.04480952052237E-09   4.04480951814167E-09  -8.97608587711823E-19  -1.95343209530050E-01  -1.95343209530050E-01
      0.00000000000000E+00   0.00000000000000E+00   9.86428636353077E-15   0.00000000000000E+00   9.86428636353077E-15
      4.03011053416194E-18  -1.95381311720358E-01  -1.94106972432724E-01   0.00000000000000E+00  -4.47222068945280E-17
     -9.55804421465311E-23  -4.04481933770573E-09  -4.04481938242804E-09  -3.13250194645012E-18
      3.99014417776563E-07
      0.00000000000000E+00  -4.04456669240786E-12   0.00000000000000E+00   1.21732585851475E-19   1.23815670197113E-22
      4.04459340143079E-09   4.04459340155264E-09  -8.97615831601398E-19  -1.95339000863059E-01  -1.95339000863059E-01
      0.00000000000000E+00   0.00000000000000E+00   9.09799965332866E-15   0.00000000000000E+00   9.09799965332866E-15
      4.03015602416021E-18  -1.95388791517607E-01  -1.94114520563131E-01   0.00000000000000E+00  -4.62799691165136E-17
     -9.55814722708138E-23  -4.04460245327224E-09  -4.04460249955230E-09  -3.13254019255881E-18
      4.04014417776563E-07
      0.00000000000000E+00  -4.04456669240786E-12   0.00000000000000E+00   2.93071497627191E-17   1.23819279998857E-22
      4.04451859177072E-09   4.04451862107799E-09  -8.97619674723176E-19  -1.95336516544670E-01  -1.95336516544670E-01
      0.00000000000000E+00   0.00000000000000E+00   6.81740492517622E-15   0.00000000000000E+00   6.81740492517622E-15
      4.03019011118483E-18  -1.95396278280541E-01  -1.94122031615565E-01   0.00000000000000E+00  -6.92982039433555E-17
     -9.55823747420730E-23  -4.04452536918462E-09  -4.04452543848292E-09  -3.13257043646166E-18
      4.09014417776563E-07
      0.00000000000000E+00  -4.04465853714506E-12   0.00000000000000E+00   2.54450448489857E-17   1.23825544336595E-22
      4.04465339263086E-09   4.04465341807603E-09  -8.97618204979823E-19  -1.95336796596288E-01  -1.95336796596288E-01
      0.00000000000000E+00   0.00000000000000E+00   2.69657656234249E-15   0.00000000000000E+00   2.69657656234249E-15
      4.03020359406765E-18  -1.95402789733961E-01  -1.94128501898500E-01   0.00000000000000E+00  -5.18340119449768E-17
     -9.55829780069249E-23  -4.04465606281849E-09  -4.04465611465260E-09  -3.13258538908782E-18
      4.14014417776563E-07
      0.00000000000000E+00  -4.04502591609389E-12   0.00000000000000E+00   2.23240495071954E-16   1.23834738312171E-22
      4.04506674439668E-09   4.04506696763730E-09  -8.97609417232390E-19  -1.95340948018580E-01  -1.95340948018580E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.48380186475775E-15   0.00000000000000E+00  -3.48380186475775E-15
      4.03018617505832E-18  -1.95407065732267E-01  -1.94132649614865E-01   0.00000000000000E+00  -2.29477098665230E-16
     -9.55830788710634E-23  -4.04506325435824E-09  -4.04506348383543E-09  -3.13257675782593E-18
      4.19014417776563E-07
      0.00000000000000E+00  -4.04576067399155E-12   0.00000000000000E+00   8.20522778622613E-17   1.23846859655131E-22
      4.04581966941313E-09   4.04581975146554E-09  -8.97591443262069E-19  -1.95350024921576E-01  -1.95350024921576E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17621060768828E-14   0.00000000000000E+00  -1.17621060768828E-14
      4.03012736452794E-18  -1.95407618117108E-01  -1.94132967392639E-01   0.00000000000000E+00  -5.45299570191608E-17
     -9.55824563085345E-23  -4.04580793482940E-09  -4.04580798935946E-09  -3.13253592126587E-18
      4.24014417776563E-07
      0.00000000000000E+00  -4.04695465557525E-12   0.00000000000000E+00   5.99515005337674E-16   1.23861529293261E-22
      4.04695336708469E-09   4.04695396659982E-09  -8.97562847453552E-19  -1.95364870588418E-01  -1.95364870588418E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.19164797604859E-14   0.00000000000000E+00  -2.19164797604859E-14
      4.03001778212914E-18  -1.95402834093685E-01  -1.94127829386192E-01   0.00000000000000E+00  -5.46120817989812E-16
     -9.55808928959363E-23  -4.04693150399915E-09  -4.04693205012006E-09  -3.13245493467558E-18
      4.29014417776563E-07
      0.00000000000000E+00  -4.04842417137057E-12   0.00000000000000E+00   1.30329489768921E-16   1.23877856124539E-22
      4.04847678731867E-09   4.04847691764829E-09  -8.97523003899768E-19  -1.95385916066131E-01  -1.95385916066131E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.33892348722360E-14   0.00000000000000E+00  -3.33892348722360E-14
      4.02985083595478E-18  -1.95391132923784E-01  -1.94115651862270E-01   0.00000000000000E+00  -1.39636006035320E-17
     -9.55782053212569E-23  -4.04844351444972E-09  -4.04844352841342E-09  -3.13232783205501E-18
      4.34014417776563E-07
      0.00000000000000E+00  -4.05035291085193E-12   0.00000000000000E+00   6.01431131781457E-17   1.23894381145317E-22
      4.05035028906391E-09   4.05035034920715E-09  -8.97472502522364E-19  -1.95412956751439E-01  -1.95412956751439E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.52145215739703E-14   0.00000000000000E+00  -4.52145215739703E-14
      4.02962476334691E-18  -1.95371192194814E-01  -1.94095124591704E-01   0.00000000000000E+00   1.18312323478718E-16
     -9.55742818178674E-23  -4.05030525299780E-09  -4.05030513468558E-09  -3.13215226082454E-18
      4.39014417776563E-07
      0.00000000000000E+00  -4.05246533980770E-12   0.00000000000000E+00   8.99635430433495E-17   1.23909015296493E-22
      4.05247247621412E-09   4.05247256617779E-09  -8.97413580656190E-19  -1.95444914135767E-01  -1.95444914135767E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59824838857290E-14   0.00000000000000E+00  -5.59824838857290E-14
      4.02934485092748E-18  -1.95342225282120E-01  -1.94065492452187E-01   0.00000000000000E+00   1.36038923067266E-16
     -9.55691281380833E-23  -4.05241671973273E-09  -4.05241658369390E-09  -3.13193127027129E-18
      4.44014417776563E-07
      0.00000000000000E+00  -4.05466961350068E-12   0.00000000000000E+00   4.24048472910317E-17   1.23919042762114E-22
      4.05466684894013E-09   4.05466689134510E-09  -8.97350506754146E-19  -1.95479618039404E-01  -1.95479618039404E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.38423133096340E-14   0.00000000000000E+00  -6.38423133096340E-14
      4.02902563936093E-18  -1.95304308464144E-01  -1.94026886746766E-01   0.00000000000000E+00   2.37883587613054E-16
     -9.55629122581674E-23  -4.05460328691528E-09  -4.05460304903179E-09  -3.13167513260678E-18
      4.49014417776563E-07
      0.00000000000000E+00  -4.05659835298204E-12   0.00000000000000E+00   2.22675636542552E-17   1.23921248865330E-22
      4.05667427219155E-09   4.05667429445924E-09  -8.97289857521280E-19  -1.95513640330821E-01  -1.95513640330821E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.65540108309312E-14   0.00000000000000E+00  -6.65540108309312E-14
      4.02869286930677E-18  -1.95258728583156E-01  -1.93980675254623E-01   0.00000000000000E+00   2.84440842096635E-16
     -9.55560138362359E-23  -4.05660802488916E-09  -4.05660774044841E-09  -3.13140301178549E-18
      4.54014417776563E-07
      0.00000000000000E+00  -4.05815971351457E-12   0.00000000000000E+00   2.34359245269328E-17   1.23912111943284E-22
      4.05815255309109E-09   4.05815257652714E-09  -8.97240611029402E-19  -1.95542224336680E-01  -1.95542224336680E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16299080214547E-14   0.00000000000000E+00  -6.16299080214547E-14
      4.02838471976667E-18  -1.95208316407201E-01  -1.93929795771698E-01   0.00000000000000E+00   2.87202103537578E-16
     -9.55490571435323E-23  -4.05809123382112E-09  -4.05809094661912E-09  -3.13114410873727E-18
      4.56514417776563E-07
      0.00000000000000E+00  -4.05871078193781E-12   0.00000000000000E+00   1.13972741599426E-17   1.23904258395749E-22
      4.05871161941026E-09   4.05871163080766E-09  -8.97220110033411E-19  -1.95554478830692E-01  -1.95554478830692E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.69378466507685E-14   0.00000000000000E+00  -5.69378466507685E-14
      4.02824237515004E-18  -1.95182362355961E-01  -1.93903664098098E-01   0.00000000000000E+00   2.91506825971755E-16
     -9.55456588724735E-23  -4.05865498446774E-09  -4.05865469296101E-09  -3.13102226511663E-18
      4.57358167776563E-07
      0.00000000000000E+00  -4.05889447141223E-12   0.00000000000000E+00   1.00591173436047E-17   1.23901216225284E-22
      4.05887788143246E-09   4.05887789149170E-09  -8.97213711303335E-19  -1.95558355499302E-01  -1.95558355499302E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.50879195144472E-14   0.00000000000000E+00  -5.50879195144472E-14
      4.02819589471795E-18  -1.95173536781852E-01  -1.93894785557030E-01   0.00000000000000E+00   2.88962775501376E-16
     -9.55445249266785E-23  -4.05882309253486E-09  -4.05882280357218E-09  -3.13098218341462E-18
      4.58497230276563E-07
      0.00000000000000E+00  -4.05907816088664E-12   0.00000000000000E+00   8.06383874920450E-18   1.23896352606413E-22
      4.05905657510785E-09   4.05905658317181E-09  -8.97206152696514E-19  -1.95563046219784E-01  -1.95563046219784E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.20733511981129E-14   0.00000000000000E+00  -5.20733511981129E-14
      4.02813657991635E-18  -1.95161553763149E-01  -1.93882745287081E-01   0.00000000000000E+00   2.83685256319749E-16
     -9.55430279339085E-23  -4.05900479350577E-09  -4.05900450982061E-09  -3.13093042721984E-18
      4.60034964651563E-07
      0.00000000000000E+00  -4.05917000562385E-12   0.00000000000000E+00   7.62798801112424E-18   1.23888302855733E-22
      4.05920173187688E-09   4.05920173950499E-09  -8.97198259898693E-19  -1.95568204794040E-01  -1.95568204794040E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.69857826926110E-14   0.00000000000000E+00  -4.69857826926110E-14
      4.02806432826317E-18  -1.95145396657755E-01  -1.93866540842540E-01   0.00000000000000E+00   2.70192893525551E-16
     -9.55410962809523E-23  -4.05915502391510E-09  -4.05915475372230E-09  -3.13086606836448E-18
      4.62110906057813E-07
      0.00000000000000E+00  -4.05917000562385E-12   0.00000000000000E+00   1.29501729857123E-17   1.23874480494379E-22
      4.05918941886843E-09   4.05918943181872E-09  -8.97192726084709E-19  -1.95572538551727E-01  -1.95572538551727E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.80786493975022E-14   0.00000000000000E+00  -3.80786493975022E-14
      4.02798527921819E-18  -1.95124036538448E-01  -1.93845181791813E-01   0.00000000000000E+00   2.37627824728836E-16
     -9.55387275670909E-23  -4.05915159079706E-09  -4.05915135316933E-09  -3.13079255313348E-18
      4.64913426956250E-07
      0.00000000000000E+00  -4.05871078193781E-12   0.00000000000000E+00   5.85374640833508E-17   1.23849868004272E-22
      4.05870651006860E-09   4.05870656860619E-09  -8.97197005629961E-19  -1.95572281832499E-01  -1.95572281832499E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.19154108108225E-14   0.00000000000000E+00  -2.19154108108225E-14
      4.02792386082140E-18  -1.95097252079536E-01  -1.93818544379492E-01   0.00000000000000E+00   1.37159758724219E-16
     -9.55361807100478E-23  -4.05868479035504E-09  -4.05868465319538E-09  -3.13072685519143E-18
      4.68696830169141E-07
      0.00000000000000E+00  -4.05696573193087E-12   0.00000000000000E+00   3.39042816883170E-16   1.23804717672873E-22
      4.05698423561606E-09   4.05698457465901E-09  -8.97230511387228E-19  -1.95557337273277E-01  -1.95557337273277E-01
      0.00000000000000E+00   0.00000000000000E+00   8.28574017119371E-15   0.00000000000000E+00   8.28574017119371E-15
      4.02795520911738E-18  -1.95068538021648E-01  -1.93790363417817E-01   0.00000000000000E+00  -2.59347356738237E-16
     -9.55345415555036E-23  -4.05699260105172E-09  -4.05699286039917E-09  -3.13072469773015E-18
      4.73696830169141E-07
      0.00000000000000E+00  -4.05237349507050E-12   0.00000000000000E+00   4.24832381786327E-17   1.23723418227637E-22
      4.05236630787685E-09   4.05236635036021E-09  -8.97337473850907E-19  -1.95504121409873E-01  -1.95504121409873E-01
      0.00000000000000E+00   0.00000000000000E+00   6.36420655582400E-14   0.00000000000000E+00   6.36420655582400E-14
      4.02827341944517E-18  -1.95053967286471E-01  -1.93777230156988E-01   0.00000000000000E+00  -1.73459899812252E-16
     -9.55371041109034E-23  -4.05242981896578E-09  -4.05242999242577E-09  -3.13093594559426E-18
      4.78696830169141E-07
      0.00000000000000E+00  -4.04502591609389E-12   0.00000000000000E+00  -7.37978110812337E-17   1.23622164897188E-22
      4.04504880235360E-09   4.04504872855592E-09  -8.97519063774579E-19  -1.95410558818102E-01  -1.95410558818102E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33551229183430E-13   0.00000000000000E+00   1.33551229183430E-13
      4.02894117559109E-18  -1.95074346321170E-01  -1.93799892613086E-01   0.00000000000000E+00  -3.44587895096647E-16
     -9.55460180316828E-23  -4.04518193519711E-09  -4.04518227978510E-09  -3.13142211181651E-18
      4.81196830169141E-07
      0.00000000000000E+00  -4.04070921344514E-12   0.00000000000000E+00  -8.81127668002374E-17   1.23566923281628E-22
      4.04068247715278E-09   4.04068238904014E-09  -8.97629809364199E-19  -1.95352930544468E-01  -1.95352930544469E-01
      0.00000000000000E+00   0.00000000000000E+00   1.71904308671392E-13   0.00000000000000E+00   1.71904308671392E-13
      4.02937093636277E-18  -1.95094764190445E-01  -1.93821674051279E-01   0.00000000000000E+00  -4.92770507281779E-16
     -9.55522627336746E-23  -4.04085380057821E-09  -4.04085429334881E-09  -3.13174112699857E-18
      4.84571830169141E-07
      0.00000000000000E+00  -4.03345347920575E-12   0.00000000000000E+00  -1.08086063867455E-16   1.23485596100516E-22
      4.03345603380794E-09   4.03345592572200E-09  -8.97817719715249E-19  -1.95254065529420E-01  -1.95254065529420E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28792219269984E-13   0.00000000000000E+00   2.28792219269984E-13
      4.03014311010280E-18  -1.95144658278239E-01  -1.93873826979239E-01   0.00000000000000E+00  -7.21878142830490E-16
     -9.55644022805332E-23  -4.03368399606304E-09  -4.03368471794128E-09  -3.13232539038756E-18
      4.89128080169141E-07
      0.00000000000000E+00  -4.02142181863156E-12   0.00000000000000E+00  -3.25356200342004E-17   1.23370480483965E-22
      4.02139914667663E-09   4.02139911414114E-09  -8.98140863397118E-19  -1.95081895150604E-01  -1.95081895150604E-01
      0.00000000000000E+00   0.00000000000000E+00   3.10210019886139E-13   0.00000000000000E+00   3.10210019886139E-13
      4.03155650450591E-18  -1.95260864928781E-01  -1.93993806627827E-01   0.00000000000000E+00  -1.17485121460693E-15
     -9.55883578201078E-23  -4.02170814930972E-09  -4.02170932416103E-09  -3.13341564110879E-18
      4.94128080169141E-07
      0.00000000000000E+00  -4.00599190278069E-12   0.00000000000000E+00  -5.13531598181070E-17   1.23251598014130E-22
      4.00599996231330E-09   4.00599991096027E-09  -8.98567124866535E-19  -1.94851920670466E-01  -1.94851920670467E-01
      0.00000000000000E+00   0.00000000000000E+00   3.95603563698505E-13   0.00000000000000E+00   3.95603563698505E-13
      4.03353452232440E-18  -1.95454671439934E-01  -1.94192437919478E-01   0.00000000000000E+00  -1.58155928648676E-15
     -9.56240687171066E-23  -4.00639393296458E-09  -4.00639551452396E-09  -3.13496739745786E-18
      4.99128080169141E-07
      0.00000000000000E+00  -3.98955169482055E-12   0.00000000000000E+00  -1.26285084080606E-16   1.23158846486765E-22
      3.98956483100027E-09   3.98956470471531E-09  -8.99038507480715E-19  -1.94594244577743E-01  -1.94594244577743E-01
      0.00000000000000E+00   0.00000000000000E+00   4.64103531305942E-13   0.00000000000000E+00   4.64103531305942E-13
      4.03585503998093E-18  -1.95716567751380E-01  -1.94459490731375E-01   0.00000000000000E+00  -1.89247581199537E-15
     -9.56683929314030E-23  -3.99002691577071E-09  -3.99002880824662E-09  -3.13681653250022E-18
      5.04128080169141E-07
      0.00000000000000E+00  -3.97384624475806E-12   0.00000000000000E+00  -1.59571210689984E-16   1.23115421034231E-22
      3.97381688029231E-09   3.97381672072122E-09  -8.99511377571972E-19  -1.94331444248724E-01  -1.94331444248725E-01
      0.00000000000000E+00   0.00000000000000E+00   4.99686589721147E-13   0.00000000000000E+00   4.99686589721147E-13
      4.03835347292954E-18  -1.96040206688399E-01  -1.94788080049629E-01   0.00000000000000E+00  -2.13672846525253E-15
     -9.57190483070462E-23  -3.97431427058238E-09  -3.97431640731094E-09  -3.13884209535756E-18
      5.09128080169141E-07
      0.00000000000000E+00  -3.96107982628621E-12   0.00000000000000E+00  -1.29255151051103E-16   1.23147882566371E-22
      3.96108705898051E-09   3.96108692972548E-09  -8.99923683012691E-19  -1.94096172346308E-01  -1.94096172346309E-01
      0.00000000000000E+00   0.00000000000000E+00   4.84115683096278E-13   0.00000000000000E+00   4.84115683096278E-13
      4.04077405134502E-18  -1.96408614044651E-01  -1.95160503025101E-01   0.00000000000000E+00  -2.26067273185559E-15
     -9.57719730540030E-23  -3.96156878473575E-09  -3.96157104540858E-09  -3.14085036833233E-18
      5.14128080169141E-07
      0.00000000000000E+00  -3.95428331573286E-12   0.00000000000000E+00   6.90049392769526E-16   1.23283981143081E-22
      3.95426224859898E-09   3.95426293864849E-09  -9.00195665535062E-19  -1.93930944315603E-01  -1.93930944315603E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98480881934501E-13   0.00000000000000E+00   3.98480881934501E-13
      4.04276645575469E-18  -1.96792072985896E-01  -1.95546139239049E-01   0.00000000000000E+00  -2.90281362051576E-15
     -9.58211406633160E-23  -3.95465851671671E-09  -3.95466141953043E-09  -3.14257079021963E-18
      5.19128080169141E-07
      0.00000000000000E+00  -3.95667127890025E-12   0.00000000000000E+00   8.30748278113897E-15   1.23549195866751E-22
      3.95664871596572E-09   3.95665702344862E-09  -9.00233374545718E-19  -1.93886469108662E-01  -1.93886469108662E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25411571564584E-13   0.00000000000000E+00   2.25411571564584E-13
      4.04389351361251E-18  -1.97146744658752E-01  -1.95900113634208E-01   0.00000000000000E+00  -1.00261333039914E-14
     -9.58585510462099E-23  -3.95687240888679E-09  -3.95688243502019E-09  -3.14366013906680E-18
      5.24128080169141E-07
      0.00000000000000E+00  -3.97173381580229E-12   0.00000000000000E+00   4.86407137576725E-15   1.23961600645595E-22
      3.97174001329776E-09   3.97174487736926E-09  -8.99935968055406E-19  -1.94018022666935E-01  -1.94018022666935E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.79839147537018E-14   0.00000000000000E+00  -4.79839147537018E-14
      4.04365359403874E-18  -1.97414437789678E-01  -1.96163138316657E-01   0.00000000000000E+00  -5.55620141740613E-15
     -9.58744392480325E-23  -3.97169133725299E-09  -3.97169689345450E-09  -3.14371762598334E-18
      5.29128080169141E-07
      0.00000000000000E+00  -4.00286918171564E-12   0.00000000000000E+00   4.11679755830329E-14   1.24526213025872E-22
      4.00285652694060E-09   4.00289769491630E-09  -8.99206063393604E-19  -1.94380117935404E-01  -1.94380117935404E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.26983388240129E-13   0.00000000000000E+00  -4.26983388240129E-13
      4.04151867709755E-18  -1.97524076364865E-01  -1.96263092794856E-01   0.00000000000000E+00  -4.06949935642194E-14
     -9.58578970870892E-23  -4.00243001653441E-09  -4.00247071152807E-09  -3.14231261370394E-18
      5.34128080169141E-07
      0.00000000000000E+00  -4.05274087401933E-12   0.00000000000000E+00   1.22436377958326E-14   1.25227811605552E-22
      4.05272998933940E-09   4.05274223297732E-09  -8.97965606022523E-19  -1.95018362172365E-01  -1.95018362172364E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.05095447867368E-13   0.00000000000000E+00  -9.05095447867368E-13
      4.03699319985821E-18  -1.97395039441189E-01  -1.96118493429666E-01   0.00000000000000E+00  -9.54431964066584E-15
     -9.57979625535018E-23  -4.05182759320972E-09  -4.05183713752945E-09  -3.13902759383569E-18
      5.39128080169140E-07
      0.00000000000000E+00  -4.12272656377146E-12   0.00000000000000E+00   9.03608833829005E-14   1.26023779271171E-22
      4.12275225320694E-09   4.12284261409045E-09  -8.96171707820924E-19  -1.95960894196708E-01  -1.95960894196707E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46159732081324E-12   0.00000000000000E+00  -1.46159732081324E-12
      4.02968521325414E-18  -1.96943878158034E-01  -1.95645446253673E-01   0.00000000000000E+00  -8.62915557503609E-14
     -9.56842059514438E-23  -4.12129472521379E-09  -4.12138101676964E-09  -3.13351350543321E-18
      5.44128080169140E-07
      0.00000000000000E+00  -4.21255071676042E-12   0.00000000000000E+00   1.54628395044666E-14   1.26843050305334E-22
      4.21251458476255E-09   4.21253004760218E-09  -8.93837761160273E-19  -1.97207053399390E-01  -1.97207053399388E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.05650299451563E-12   0.00000000000000E+00  -2.05650299451563E-12
      4.01940269828157E-18  -1.96092859246794E-01  -1.94766334214945E-01   0.00000000000000E+00  -7.77336657019985E-15
     -9.55104532203087E-23  -4.21046577124100E-09  -4.21047354460766E-09  -3.12556493712129E-18
      5.49128080169140E-07
      0.00000000000000E+00  -4.31844769876070E-12   0.00000000000000E+00   9.68124745493965E-14   1.27577018266140E-22
      4.31844054849230E-09   4.31853736096698E-09  -8.91049389257345E-19  -1.98718121528762E-01  -1.98718121528759E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.63142398800210E-12   0.00000000000000E+00  -2.63142398800210E-12
      4.00624557834156E-18  -1.94784568423378E-01  -1.93424851321256E-01   0.00000000000000E+00  -8.83285716279401E-14
     -9.52728830389397E-23  -4.31581760840725E-09  -4.31590593697898E-09  -3.11519618908421E-18
      5.54128080169140E-07
      0.00000000000000E+00  -4.43362099921894E-12   0.00000000000000E+00   6.62201609995109E-15   1.28098833166012E-22
      4.43358127005151E-09   4.43358789206774E-09  -8.87981590606793E-19  -2.00406981693849E-01  -2.00406981693846E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.10370104813967E-12   0.00000000000000E+00  -3.10370104813967E-12
      3.99072707310085E-18  -1.92996756165548E-01  -1.91600911375484E-01   0.00000000000000E+00   6.21315429292303E-15
     -9.49787209355168E-23  -4.43049040417380E-09  -4.43048419101960E-09  -3.10274548249406E-18
      5.59128080169140E-07
      0.00000000000000E+00  -4.54594711282374E-12   0.00000000000000E+00   1.13527143311352E-15   1.28254163468746E-22
      4.54592876855927E-09   4.54592990383083E-09  -8.84909297246357E-19  -2.02131296457327E-01  -2.02131296457324E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.37265090931414E-12   0.00000000000000E+00  -3.37265090931414E-12
      3.97386381855428E-18  -1.90764484486910E-01  -1.89333327828245E-01   0.00000000000000E+00   1.37650628413987E-14
     -9.46404993052350E-23  -4.54257101798426E-09  -4.54255725292151E-09  -3.08895452130792E-18
      5.64128080169140E-07
      0.00000000000000E+00  -4.63861845266614E-12   0.00000000000000E+00   7.50377796542742E-15   1.27891212220858E-22
      4.63860033532399E-09   4.63860783910208E-09  -8.82213889179860E-19  -2.03688256635578E-01  -2.03688256635575E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.31660083725204E-12   0.00000000000000E+00  -3.31660083725204E-12
      3.95728081436802E-18  -1.88200351136768E-01  -1.86739979199976E-01   0.00000000000000E+00   7.66552612727294E-15
     -9.42849031183158E-23  -4.63529890379086E-09  -4.63529123826483E-09  -3.07506692518816E-18
      5.69128080169140E-07
      0.00000000000000E+00  -4.68986781602794E-12   0.00000000000000E+00   5.21950742840774E-16   1.26873016529640E-22
      4.68983023960868E-09   4.68983076155955E-09  -8.80384635646831E-19  -2.04812622729201E-01  -2.04812622729198E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80098152071603E-12   0.00000000000000E+00  -2.80098152071603E-12
      3.94327590676444E-18  -1.85513851136893E-01  -1.84037175666700E-01   0.00000000000000E+00   1.36747064308590E-14
     -9.39514164701153E-23  -4.68704345474517E-09  -4.68702978003883E-09  -3.06289127111761E-18
      5.74128080169140E-07
      0.00000000000000E+00  -4.67434605543987E-12   0.00000000000000E+00   1.00600364513293E-13   1.25091651560231E-22
      4.67442740309381E-09   4.67452800345844E-09  -8.80011976638933E-19  -2.05179791472654E-01  -2.05179791472652E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69002143315673E-12   0.00000000000000E+00  -1.69002143315673E-12
      3.93482579959866E-18  -1.83022985637844E-01  -1.81550812374204E-01   0.00000000000000E+00  -9.06221259526101E-14
     -9.36930245601085E-23  -4.67274735989924E-09  -4.67283798202528E-09  -3.05481382295973E-18
      5.79128080169140E-07
      0.00000000000000E+00  -4.56707140238148E-12   0.00000000000000E+00  -1.07293956577397E-15   1.22468969546866E-22
      4.56709701275961E-09   4.56709593982017E-09  -8.81774721926469E-19  -2.04413869725941E-01  -2.04413869725941E-01
      0.00000000000000E+00   0.00000000000000E+00   1.34048437566833E-13   0.00000000000000E+00   1.34048437566833E-13
      3.93549604178649E-18  -1.81149705287635E-01  -1.79710772416261E-01   0.00000000000000E+00   5.65647708229906E-15
     -9.35749169784680E-23  -4.56723564473473E-09  -4.56722998825774E-09  -3.05372131986002E-18
      5.84128080169140E-07
      0.00000000000000E+00  -4.34747063571828E-12   0.00000000000000E+00  -2.20742790568308E-15   1.18946584528731E-22
      4.34741976321390E-09   4.34741755578612E-09  -8.86400452738572E-19  -2.02111304805546E-01  -2.02111304805549E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73438642689460E-12   0.00000000000000E+00   2.73438642689460E-12
      3.94916797392097E-18  -1.80392141004787E-01  -1.79021600139612E-01   0.00000000000000E+00  -2.50951331430578E-15
     -9.36717136114477E-23  -4.35014943269960E-09  -4.35015194221301E-09  -3.06276752118240E-18
      5.89128080169140E-07
      0.00000000000000E+00  -4.00700219488998E-12   0.00000000000000E+00  -3.43072589724675E-15   1.14460408481112E-22
      4.00697727652882E-09   4.00697384580304E-09  -8.94604269330644E-19  -1.97880195971071E-01  -1.97880195971077E-01
      0.00000000000000E+00   0.00000000000000E+00   6.07233810078235E-12   0.00000000000000E+00   6.07233810078235E-12
      3.97952966442488E-18  -1.81264597908562E-01  -1.80000265170844E-01   0.00000000000000E+00  -1.40470760934644E-14
     -9.40619559298426E-23  -4.01303213682763E-09  -4.01304618390382E-09  -3.08492539509423E-18
      5.94128080169140E-07
      0.00000000000000E+00  -3.55595269046381E-12   0.00000000000000E+00  -4.56010514867383E-15   1.08931931558150E-22
      3.55602842739298E-09   3.55602386728794E-09  -9.06981643555804E-19  -1.91407308095570E-01  -1.91407308095580E-01
      0.00000000000000E+00   0.00000000000000E+00   9.95145512770938E-12   0.00000000000000E+00   9.95145512770938E-12
      4.02928694006342E-18  -1.84209005093393E-01  -1.83085526232735E-01   0.00000000000000E+00  -2.92928977046994E-14
     -9.48191798295811E-23  -3.56594602951785E-09  -3.56597532241565E-09  -3.12230529650762E-18
      5.99128080169140E-07
      0.00000000000000E+00  -3.02720253836008E-12   0.00000000000000E+00  -4.37089316024659E-15   1.02322154150303E-22
      3.02724425702096E-09   3.02723988612790E-09  -9.23854845235808E-19  -1.82552276102461E-01  -1.82552276102475E-01
      0.00000000000000E+00   0.00000000000000E+00   1.39793189524814E-11   0.00000000000000E+00   1.39793189524814E-11
      4.09918353482584E-18  -1.89493082363737E-01  -1.88534933210416E-01   0.00000000000000E+00  -4.93050465815925E-14
     -9.59955555102771E-23  -3.04116990003371E-09  -3.04121920508039E-09  -3.17532868959003E-18
      6.04128080169140E-07
      0.00000000000000E+00  -2.47273585983824E-12   0.00000000000000E+00  -5.66837817358212E-15   9.47931973472093E-23
      2.47269846765024E-09   2.47269279927217E-09  -9.45068746525252E-19  -1.71462555837654E-01  -1.71462555837672E-01
      0.00000000000000E+00   0.00000000000000E+00   1.75830119594781E-11   0.00000000000000E+00   1.75830119594781E-11
      4.18709859462322E-18  -1.97127646384447E-01  -1.96343076681048E-01   0.00000000000000E+00  -7.04186325760630E-14
     -9.75968713038707E-23  -2.49020539259897E-09  -2.49027581123164E-09  -3.24202984809797E-18
      6.09128080169140E-07
      0.00000000000000E+00  -1.95271095776923E-12   0.00000000000000E+00  -4.60299703032468E-15   8.69627427502811E-23
      1.95270512716880E-09   1.95270052417185E-09  -9.69731796808772E-19  -1.58693147447104E-01  -1.58693147447124E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01028961260285E-11   0.00000000000000E+00   2.01028961260285E-11
      4.28761307525337E-18  -2.06840461839327E-01  -2.06218926468532E-01   0.00000000000000E+00  -9.43823468561589E-14
     -9.95559373362291E-23  -1.97270903795092E-09  -1.97280342029788E-09  -3.31788127844459E-18
      6.14128080169140E-07
      0.00000000000000E+00  -1.51993855604736E-12   0.00000000000000E+00  -4.52207662551868E-15   8.01241698209151E-23
      1.51993412298484E-09   1.51992960090830E-09  -9.95914188413139E-19  -1.45306109442823E-01  -1.45306109442844E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09361017850220E-11   0.00000000000000E+00   2.09361017850220E-11
      4.39229358417848E-18  -2.18126029326842E-01  -2.17640579038542E-01   0.00000000000000E+00  -1.13758068822636E-13
     -1.01725247561159E-22  -1.54075194462439E-09  -1.54086570269332E-09  -3.39637939576534E-18
      6.19128080169140E-07
      0.00000000000000E+00  -1.20683984690690E-12   0.00000000000000E+00  -3.33124072009682E-15   7.62365228567014E-23
      1.20685670977084E-09   1.20685337853020E-09  -1.02041830938824E-18  -1.32899874268820E-01  -1.32899874268840E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96556144039760E-11   0.00000000000000E+00   1.96556144039760E-11
      4.49057165619836E-18  -2.30351931619521E-01  -2.29965521664840E-01   0.00000000000000E+00  -1.24699599516720E-13
     -1.03895528933443E-22  -1.22638429333455E-09  -1.22650899293417E-09  -3.47015334681011E-18
      6.24128080169140E-07
      0.00000000000000E+00  -1.02480357776158E-12   0.00000000000000E+00  -1.97265175335148E-15   7.75500831325798E-23
      1.02480548700040E-09   1.02480351434873E-09  -1.03894264874790E-18  -1.23466961588950E-01  -1.23466961588966E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60824886591363E-11   0.00000000000000E+00   1.60824886591363E-11
      4.57098409949404E-18  -2.42864309682761E-01  -2.42536381746906E-01   0.00000000000000E+00  -1.20261555873243E-13
     -1.05831732836722E-22  -1.04076574145189E-09  -1.04088600300787E-09  -3.53204145074614E-18
      6.29128080169140E-07
      0.00000000000000E+00  -9.76217711778802E-13   0.00000000000000E+00   3.86492471195679E-16   8.58337232088180E-23
      9.76216219902631E-10   9.76216606395188E-10  -1.04700016001531E-18  -1.18982237577618E-01  -1.18982237577628E-01
      0.00000000000000E+00   0.00000000000000E+00   1.03578025970125E-11   0.00000000000000E+00   1.03578025970125E-11
      4.62277311247910E-18  -2.55029976928048E-01  -2.54719161363706E-01   0.00000000000000E+00  -9.84900246047858E-14
     -1.07312553068151E-22  -9.86475918967489E-10  -9.86574408992201E-10  -3.57577295246379E-18
      6.34128080169140E-07
      0.00000000000000E+00  -1.07366497795599E-12   0.00000000000000E+00   1.06606917985799E-15   1.01261431564524E-22
      1.07362717748036E-09   1.07362824354964E-09  -1.04149369558795E-18  -1.20794202343514E-01  -1.20794202343517E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99243029929694E-12   0.00000000000000E+00   2.99243029929694E-12
      4.63773526397558E-18  -2.66185582096582E-01  -2.65846398540286E-01   0.00000000000000E+00  -5.98598063936787E-14
     -1.08176259772942E-22  -1.07656081404243E-09  -1.07662067384893E-09  -3.59624156838764E-18
      6.39128080169140E-07
      0.00000000000000E+00  -1.35562832118309E-12   0.00000000000000E+00   1.19394960123434E-14   1.21507293417086E-22
      1.35565965800397E-09   1.35567159750011E-09  -1.02221612802584E-18  -1.29101182562722E-01  -1.29101182562717E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.19632125994724E-12   0.00000000000000E+00  -5.19632125994724E-12
      4.61175365767585E-18  -2.75514409365485E-01  -2.75088952529366E-01   0.00000000000000E+00  -2.23796463123786E-14
     -1.08355331688626E-22  -1.35045289659374E-09  -1.35047527624016E-09  -3.58953752965001E-18
      6.44128080169139E-07
      0.00000000000000E+00  -1.88897071014720E-12   0.00000000000000E+00   5.51960335249343E-15   1.42393968880539E-22
      1.88897934317566E-09   1.88898486277915E-09  -9.92225941791019E-19  -1.42841108697226E-01  -1.42841108697213E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.32886147660649E-11   0.00000000000000E+00  -1.32886147660649E-11
      4.54531058384552E-18  -2.81924392896617E-01  -2.81333464551852E-01   0.00000000000000E+00   2.88818045923365E-14
     -1.07879675405152E-22  -1.87572512981757E-09  -1.87569624801309E-09  -3.55308464205450E-18
      6.49128080169139E-07
      0.00000000000000E+00  -2.74340230038882E-12   0.00000000000000E+00   8.76545484539118E-15   1.60100304609879E-22
      2.74337122542106E-09   2.74337999087607E-09  -9.56488320210569E-19  -1.60123049051851E-01  -1.60123049051830E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.04903608547398E-11   0.00000000000000E+00  -2.04903608547398E-11
      4.44285877957183E-18  -2.84043806471916E-01  -2.83185971537209E-01   0.00000000000000E+00   6.65166993515508E-14
     -1.06808867242855E-22  -2.72295614672057E-09  -2.72288963002133E-09  -3.48637045936125E-18
      6.54128080169139E-07
      0.00000000000000E+00  -3.94767049465391E-12   0.00000000000000E+00   1.22210105836395E-14   1.72602544204563E-22
      3.94762986405781E-09   3.94764208506857E-09  -9.19569268024006E-19  -1.78980130795500E-01  -1.78980130795473E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.62846104658567E-11   0.00000000000000E+00  -2.62846104658567E-11
      4.31143572724254E-18  -2.80417568633068E-01  -2.79182155458722E-01   0.00000000000000E+00   9.89238272301036E-14
     -1.05170155690330E-22  -3.92145639842983E-09  -3.92135747460271E-09  -3.39186645921854E-18
      6.59128080169139E-07
      0.00000000000000E+00  -5.46898672175939E-12   0.00000000000000E+00   1.53183971992276E-14   1.79603723137157E-22
      5.46898284194452E-09   5.46899816034190E-09  -8.84144629542674E-19  -1.97988163549337E-01  -1.97988163549307E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.05608098486131E-11   0.00000000000000E+00  -3.05608098486131E-11
      4.15863167799948E-18  -2.69807416306548E-01  -2.68094040263002E-01   0.00000000000000E+00   1.28667326183980E-13
     -1.02910903057025E-22  -5.43856601781937E-09  -5.43843735049329E-09  -3.27448704845680E-18
      6.64128080169139E-07
      0.00000000000000E+00  -7.23589577615779E-12   0.00000000000000E+00   1.77112856989275E-14   1.81712556636387E-22
      7.23591041293978E-09   7.23592812422566E-09  -8.51037002570260E-19  -2.16451518771094E-01  -2.16451518771060E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.37043966006566E-11   0.00000000000000E+00  -3.37043966006566E-11
      3.99010969499619E-18  -2.51375426622877E-01  -2.49106353224756E-01   0.00000000000000E+00   1.55234776620003E-13
     -9.99122644517884E-23  -7.20237896240153E-09  -7.20222372762501E-09  -3.13907269242593E-18
      6.69128080169139E-07
      0.00000000000000E+00  -9.14608262059993E-12   0.00000000000000E+00   1.90977944516523E-14   1.78924590507080E-22
      9.14609968733440E-09   9.14611878512903E-09  -8.20186877764594E-19  -2.34149629010565E-01  -2.34149629010529E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.63636213983198E-11   0.00000000000000E+00  -3.63636213983198E-11
      3.80829158800459E-18  -2.24810460157227E-01  -2.21940390484217E-01   0.00000000000000E+00   1.72320245938380E-13
     -9.60819694258685E-23  -9.10992748397655E-09  -9.10975516373071E-09  -2.98810471024000E-18
      6.74128080169139E-07
      0.00000000000000E+00  -1.10390944991843E-11   0.00000000000000E+00   1.89042110130013E-14   1.69119829904849E-22
      1.10390359420342E-08   1.10390548462454E-08  -7.91426803575673E-19  -2.51032164175107E-01  -2.51032164175067E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.91387840720681E-11   0.00000000000000E+00  -3.91387840720681E-11
      3.61259766764425E-18  -1.90570130217197E-01  -1.87104526344652E-01   0.00000000000000E+00   1.71746539983689E-13
     -9.15833290351891E-23  -1.10000878087132E-08  -1.09999160621733E-08  -2.82117086406858E-18
      6.79128080169139E-07
      0.00000000000000E+00  -1.27228840664099E-11   0.00000000000000E+00   1.68200493057513E-14   1.49440058452153E-22
      1.27228387587991E-08   1.27228555788485E-08  -7.64576319985286E-19  -2.67105707034008E-01  -2.67105707033966E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.19457825239613E-11   0.00000000000000E+00  -4.19457825239613E-11
      3.40286875502445E-18  -1.49988853124133E-01  -1.45993608086863E-01   0.00000000000000E+00   1.55466101577880E-13
     -8.71384954800918E-23  -1.26810652624261E-08  -1.26809097963246E-08  -2.63829243503916E-18
      6.84128080169139E-07
      0.00000000000000E+00  -1.39864839609110E-11   0.00000000000000E+00   1.26560055098374E-14   1.19165188075429E-22
      1.39864373808134E-08   1.39864500368191E-08  -7.39403023528801E-19  -2.82399969158933E-01  -2.82399969158889E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.39986248223464E-11   0.00000000000000E+00  -4.39986248223464E-11
      3.18287563091272E-18  -1.05333104085033E-01  -1.00940367351839E-01   0.00000000000000E+00   1.35288686814070E-13
     -8.22904715656016E-23  -1.39425867006835E-08  -1.39424514119967E-08  -2.44347260738391E-18
      6.89128080169139E-07
      0.00000000000000E+00  -1.40877887060509E-11   0.00000000000000E+00   1.16709715229608E-15   7.67071092709229E-23
      1.40878115380754E-08   1.40878127051726E-08  -7.15718952441785E-19  -2.96953584221910E-01  -2.96953584221866E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.45014444894401E-11   0.00000000000000E+00  -4.45014444894401E-11
      2.96036840846551E-18  -6.22869810870113E-02  -5.78624420271847E-02   0.00000000000000E+00   1.14683172473005E-13
     -6.63569242029013E-23  -1.40434259438556E-08  -1.40433112606832E-08  -2.24464945602373E-18
      6.94128080169139E-07
      0.00000000000000E+00  -1.17793630810769E-11   0.00000000000000E+00   2.00385200798138E-14   3.82374137825042E-23
      1.17793495661359E-08   1.17793696046560E-08  -6.91569539381787E-19  -3.10829382770591E-01  -3.10829382770553E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.82652477287425E-11   0.00000000000000E+00  -3.82652477287425E-11
      2.76904216982180E-18  -3.21759997065051E-02  -2.84768024958619E-02   0.00000000000000E+00   5.18094258599357E-14
     -3.71621727562095E-23  -1.17411561663531E-08  -1.17411043569272E-08  -2.07747263044001E-18
      6.99128080169139E-07
      0.00000000000000E+00  -8.83610663252453E-12   0.00000000000000E+00  -2.88707277783584E-14   1.88834840332820E-23
      8.83609147489743E-09   8.83606260416967E-09  -6.65174248623187E-19  -3.24073900094709E-01  -3.24073900094681E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78094510823301E-11   0.00000000000000E+00  -2.78094510823301E-11
      2.62999491441015E-18  -1.73873395422766E-02  -1.46121615248327E-02   0.00000000000000E+00   6.87611591462790E-14
     -1.89510872364474E-23  -8.80832191424647E-09  -8.80825315308734E-09  -1.96482066578696E-18
      7.04128080169139E-07
      0.00000000000000E+00  -7.15856250742905E-12   0.00000000000000E+00  -1.63859285787953E-14   1.10065664067193E-23
      7.15853163715765E-09   7.15851525122908E-09  -6.37615045906695E-19  -3.36689211707077E-01  -3.36689211707056E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10014222362247E-11   0.00000000000000E+00  -2.10014222362247E-11
      2.52498780322903E-18  -1.12133261117745E-02  -8.96453764720743E-03   0.00000000000000E+00   4.09976262715712E-14
     -1.17171609369232E-23  -7.13755482661911E-09  -7.13751382899285E-09  -1.88737275732233E-18
      7.09128080169139E-07
      0.00000000000000E+00  -6.48396291263977E-12   0.00000000000000E+00  -3.15028776145655E-15   7.59967412917812E-24
      6.48398895248998E-09   6.48398580220222E-09  -6.10122153959398E-19  -3.48664335074140E-01  -3.48664335074123E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77639594442769E-11   0.00000000000000E+00  -1.77639594442769E-11
      2.43616800600764E-18  -8.50847131299771E-03  -6.47118322039850E-03   0.00000000000000E+00   2.12451263299893E-14
     -8.60989889695185E-24  -6.46624308788427E-09  -6.46622184275795E-09  -1.82604585204824E-18
      7.14128080169139E-07
      0.00000000000000E+00  -6.23873746429567E-12   0.00000000000000E+00  -2.28405912170677E-15   5.81282721583872E-24
      6.23876342804448E-09   6.23876114398537E-09  -5.83398156259631E-19  -3.59962252955077E-01  -3.59962252955061E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60939812106425E-11   0.00000000000000E+00  -1.60939812106425E-11
      2.35569809995443E-18  -7.08218947043488E-03  -5.12163453947645E-03   0.00000000000000E+00   1.73637953306151E-14
     -6.90894673037539E-24  -6.22268452657004E-09  -6.22266716277472E-09  -1.77229994369480E-18
      7.19128080169139E-07
      0.00000000000000E+00  -6.13908592442550E-12   0.00000000000000E+00  -8.63840396272168E-16   4.69979572778798E-24
      6.13906253201389E-09   6.13906166817350E-09  -5.58058426728082E-19  -3.70462617590065E-01  -3.70462617590050E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48509295704645E-11   0.00000000000000E+00  -1.48509295704645E-11
      2.28144345210211E-18  -6.18741539781367E-03  -4.25787942066704E-03   0.00000000000000E+00   1.37058706440286E-14
     -5.79758158825310E-24  -6.12422444447369E-09  -6.12421073860305E-09  -1.72338502537402E-18
      7.24128080169139E-07
      0.00000000000000E+00  -6.08572413210793E-12   0.00000000000000E+00  -4.23260285416108E-16   3.95023775249966E-24
      6.08573194092922E-09   6.08573151766894E-09  -5.35031159930710E-19  -3.79876269422222E-01  -3.79876269422209E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34080477797825E-11   0.00000000000000E+00  -1.34080477797825E-11
      2.21440321320320E-18  -5.57902460318017E-03  -3.66583543497385E-03   0.00000000000000E+00   1.11677271110363E-14
     -5.03204447157394E-24  -6.07233463761627E-09  -6.07232346988917E-09  -1.67937205327248E-18
      7.29128080169139E-07
      0.00000000000000E+00  -6.04788410037843E-12   0.00000000000000E+00  -3.84318005232408E-16   3.44250248769761E-24
      6.04784434170776E-09   6.04784395738976E-09  -5.15797759793701E-19  -3.87671895181021E-01  -3.87671895181010E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12451126765175E-11   0.00000000000000E+00  -1.12451126765175E-11
      2.15817764982061E-18  -5.16726696040197E-03  -3.26533251883785E-03   0.00000000000000E+00   8.78543580309613E-15
     -4.52566186906082E-24  -6.03660763014904E-09  -6.03659884471324E-09  -1.64237989002691E-18
      7.34128080169139E-07
      0.00000000000000E+00  -6.01445261603489E-12   0.00000000000000E+00  -2.53881988477706E-16   3.12004233165085E-24
      6.01446188761904E-09   6.01446163373705E-09  -5.02486264962425E-19  -3.93041833361430E-01  -3.93041833361422E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.84767828785279E-12   0.00000000000000E+00  -7.84767828785279E-12
      2.11893925838134E-18  -4.91585225999298E-03  -3.02336451829026E-03   0.00000000000000E+00   5.78882284963403E-15
     -4.25170196407013E-24  -6.00661974427204E-09  -6.00661395544920E-09  -1.61645299341892E-18
      7.39128080169139E-07
      0.00000000000000E+00  -5.97945977115882E-12   0.00000000000000E+00  -3.26083792214583E-16   2.95831790121487E-24
      5.97948586385397E-09   5.97948553777018E-09  -4.97792159624164E-19  -3.94932151007528E-01  -3.94932151007525E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79523059423903E-12   0.00000000000000E+00  -2.79523059423903E-12
      2.10496310541015E-18  -4.81704902615601E-03  -2.93398903455633E-03   0.00000000000000E+00   2.20245442306240E-15
     -4.22645874735556E-24  -5.97669250963036E-09  -5.97669030717594E-09  -1.60717094578598E-18
      7.44128080169139E-07
      0.00000000000000E+00  -5.93638458940849E-12   0.00000000000000E+00  -4.52436860511616E-16   2.95837125989698E-24
      5.93641079975269E-09   5.93641034731583E-09  -5.04735581669448E-19  -3.92137968581770E-01  -3.92137968581774E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07908067114850E-12   0.00000000000000E+00   4.07908067114850E-12
      2.12535850876589E-18  -4.89352785756254E-03  -3.02187386865366E-03   0.00000000000000E+00  -2.42513624298094E-15
     -4.53034289014877E-24  -5.94048700285074E-09  -5.94048942798698E-09  -1.62062292709644E-18
      7.49128080169138E-07
      0.00000000000000E+00  -5.87383832337017E-12   0.00000000000000E+00  -7.05566457773813E-16   3.15301055526785E-24
      5.87385953143405E-09   5.87385882586760E-09  -5.26259490672588E-19  -3.83447290341830E-01  -3.83447290341842E-01
      0.00000000000000E+00   0.00000000000000E+00   1.25609931358145E-11   0.00000000000000E+00   1.25609931358145E-11
      2.18816347444496E-18  -5.22175774478113E-03  -3.36714025332024E-03   0.00000000000000E+00  -8.46541268407718E-15
     -5.38144668950467E-24  -5.88641135359072E-09  -5.88641981900341E-09  -1.66190398377238E-18
      7.54128080169138E-07
      0.00000000000000E+00  -5.76582891241411E-12   0.00000000000000E+00  -1.23489372584880E-15   3.62450595406919E-24
      5.76584467016160E-09   5.76584343526787E-09  -5.64666469404996E-19  -3.67778150105793E-01  -3.67778150105815E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21495935615552E-11   0.00000000000000E+00   2.21495935615552E-11
      2.29891144225274E-18  -6.00017828783104E-03  -4.17657363073416E-03   0.00000000000000E+00  -1.65319419900768E-14
     -7.34537044600477E-24  -5.78797649688743E-09  -5.78799302882943E-09  -1.73424497284774E-18
      7.59128080169138E-07
      0.00000000000000E+00  -5.54631999048813E-12   0.00000000000000E+00  -2.44985494964094E-15   4.52726462184322E-24
      5.54629916323715E-09   5.54629671338220E-09  -6.20756083895951E-19  -3.44270755125062E-01  -3.44270755125094E-01
      0.00000000000000E+00   0.00000000000000E+00   3.25773950357958E-11   0.00000000000000E+00   3.25773950357958E-11
      2.46179841743172E-18  -7.73244833494428E-03  -5.97473300085843E-03   0.00000000000000E+00  -2.75636270859006E-14
     -1.18935780670278E-23  -5.57884654479091E-09  -5.57887410841801E-09  -1.84104233353577E-18
      7.64128080169138E-07
      0.00000000000000E+00  -5.05586909379993E-12   0.00000000000000E+00  -5.25196632638918E-15   6.03751690828926E-24
      5.05591159032497E-09   5.05590633835865E-09  -6.92692717771408E-19  -3.12365143116955E-01  -3.12365143117000E-01
      0.00000000000000E+00   0.00000000000000E+00   4.47782239256812E-11   0.00000000000000E+00   4.47782239256812E-11
      2.68568953706012E-18  -1.16494633159404E-02  -1.00424135462383E-02   0.00000000000000E+00  -4.28667664061771E-14
     -2.24092239967629E-23  -5.10064169551790E-09  -5.10068456228433E-09  -1.99299681928872E-18
      7.69128080169138E-07
      0.00000000000000E+00  -4.02674881338960E-12   0.00000000000000E+00  -1.07278579978907E-14   7.75575495063499E-24
      4.02674236269155E-09   4.02673163483356E-09  -7.76239764232737E-19  -2.71968465565020E-01  -2.71968465565080E-01
      0.00000000000000E+00   0.00000000000000E+00   6.05566769681330E-11   0.00000000000000E+00   6.05566769681330E-11
      2.98847292190079E-18  -2.01855531739203E-02  -1.88977946078852E-02   0.00000000000000E+00  -6.45809296573094E-14
     -4.31109509442125E-23  -4.08722373087200E-09  -4.08728831180170E-09  -2.21223315766805E-18
      7.74128080169138E-07
      0.00000000000000E+00  -2.44499874920157E-12   0.00000000000000E+00  -1.63134451534641E-14   6.28062751219593E-24
      2.44499854972445E-09   2.44498223627930E-09  -8.68569495086356E-19  -2.23897828378365E-01  -2.23897828378442E-01
      0.00000000000000E+00   0.00000000000000E+00   7.71423565008890E-11   0.00000000000000E+00   7.71423565008890E-11
      3.37418470440523E-18  -3.57364758841692E-02  -3.49418489727498E-02   0.00000000000000E+00  -9.84100696575116E-14
     -6.90627297414820E-23  -2.52202618271046E-09  -2.52212459278019E-09  -2.50561520931888E-18
      7.79128080169138E-07
      0.00000000000000E+00  -1.05061194891690E-12   0.00000000000000E+00  -1.57108877300788E-14  -3.98166544529276E-24
      1.05062255388093E-09   1.05060684299319E-09  -9.70605406392320E-19  -1.70365766419244E-01  -1.70365766419329E-01
      0.00000000000000E+00   0.00000000000000E+00   8.55984515519276E-11   0.00000000000000E+00   8.55984515519276E-11
      3.80217696216487E-18  -5.71152712169095E-02  -5.67572978796779E-02   0.00000000000000E+00  -1.49754958709808E-13
     -8.52760475562188E-23  -1.13605553958633E-09  -1.13620529454512E-09  -2.83157155577255E-18
      7.84128080169138E-07
      0.00000000000000E+00  -3.37253875026038E-13   0.00000000000000E+00  -8.28347083540642E-15  -2.00411424380088E-23
      3.37202305341226E-10   3.37194021870371E-10  -1.08278057492615E-18  -1.14535088399110E-01  -1.14535088399193E-01
      0.00000000000000E+00   0.00000000000000E+00   8.29791874194967E-11   0.00000000000000E+00   8.29791874194967E-11
      4.21707289926236E-18  -8.08648703533481E-02  -8.07324916479901E-02   0.00000000000000E+00  -2.20145988824435E-13
     -9.25346685781382E-23  -4.19953063300951E-10  -4.20173209289868E-10  -3.13429232433620E-18
      7.89128080169138E-07
      0.00000000000000E+00  -9.34060977400547E-14   0.00000000000000E+00  -3.69242362627067E-15  -3.18864632424807E-23
      9.33688830047546E-11   9.33651905810964E-11  -1.19201838091122E-18  -6.32350506609986E-02  -6.32350506610685E-02
      0.00000000000000E+00   0.00000000000000E+00   6.99411504525872E-11   0.00000000000000E+00   6.99411504525872E-11
      4.56677865152529E-18  -1.04692739003876E-01  -1.04641288506150E-01   0.00000000000000E+00  -2.84647221728167E-13
     -9.84360615829492E-23  -1.63021693811857E-10  -1.63306341033684E-10  -3.37476027061407E-18
      7.94128080169138E-07
      0.00000000000000E+00  -4.18812001666322E-14   0.00000000000000E+00  -1.39279387625512E-15  -3.38730143042510E-23
      4.19046251359250E-11   4.19032323420149E-11  -1.26479423235730E-18  -3.02547782486016E-02  -3.02547782486482E-02
      0.00000000000000E+00   0.00000000000000E+00   4.65956671206631E-11   0.00000000000000E+00   4.65956671206631E-11
      4.79975698712861E-18  -1.27729463849863E-01  -1.27701581993024E-01   0.00000000000000E+00  -2.64257777030946E-13
     -1.03294811781090E-22  -8.82346416855435E-11  -8.84988994626778E-11  -3.53496275477130E-18
      7.99128080169138E-07
      0.00000000000000E+00  -3.87584791015763E-14   0.00000000000000E+00  -3.78189132079153E-16  -2.71881879699401E-23
      3.87288492978526E-11   3.87284711086934E-11  -1.29798323428828E-18  -1.57182424254737E-02  -1.57182424255000E-02
      0.00000000000000E+00   0.00000000000000E+00   2.63020929137682E-11   0.00000000000000E+00   2.63020929137682E-11
      4.93126745169745E-18  -1.49767396620100E-01  -1.49746908709236E-01   0.00000000000000E+00  -1.96019097652110E-13
     -1.06521704393455E-22  -6.48345449247028E-11  -6.50305640224614E-11  -3.63328421740916E-18
      8.04128080169138E-07
      0.00000000000000E+00  -4.25241133270849E-14   0.00000000000000E+00  -5.11281909015903E-17  -1.19472944573493E-23
      4.25081030257217E-11   4.25080518975188E-11  -1.31045136366113E-18  -1.01686337123276E-02  -1.01686337123432E-02
      0.00000000000000E+00   0.00000000000000E+00   1.55587147776390E-11   0.00000000000000E+00   1.55587147776390E-11
      5.00906102558565E-18  -1.70775420469810E-01  -1.70757126658477E-01   0.00000000000000E+00  -1.56467711148160E-13
     -1.08904032011795E-22  -5.79102989639009E-11  -5.80667666751579E-11  -3.69860966192452E-18
      8.09128080169138E-07
      0.00000000000000E+00  -4.61060580781784E-14   0.00000000000000E+00   8.34461084519311E-18   9.86872051983423E-24
      4.61681742184662E-11   4.61681825630869E-11  -1.31476310943879E-18  -7.84990787772319E-03  -7.84990787773396E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07652538239925E-11   0.00000000000000E+00   1.07652538239925E-11
      5.06288729470561E-18  -1.90776131924862E-01  -1.90758195288684E-01   0.00000000000000E+00  -1.41731612823526E-13
     -1.10943297113367E-22  -5.67917047741451E-11  -5.69334363870796E-11  -3.74812418526681E-18
      8.14128080169138E-07
      0.00000000000000E+00  -4.92287791432343E-14   0.00000000000000E+00   3.13525537261129E-17   3.19135108838506E-23
      4.92302859965352E-11   4.92303173491208E-11  -1.31612801579148E-18  -6.62750350079147E-03  -6.62750350080005E-03
      0.00000000000000E+00   0.00000000000000E+00   8.57754893649424E-12   0.00000000000000E+00   8.57754893649424E-12
      5.10577503938808E-18  -2.09810268395018E-01  -2.09792056392604E-01   0.00000000000000E+00  -1.35618862390709E-13
     -1.12802546649185E-22  -5.76722474231118E-11  -5.78078662856153E-11  -3.78964702359659E-18
      8.19128080169138E-07
      0.00000000000000E+00  -5.19841212594601E-14   0.00000000000000E+00   3.21037189623975E-17   4.99972660903056E-23
      5.20119159828835E-11   5.20119480866524E-11  -1.31636401776193E-18  -5.84037548436168E-03  -5.84037548436912E-03
      0.00000000000000E+00   0.00000000000000E+00   7.43723950884320E-12   0.00000000000000E+00   7.43723950884320E-12
      5.14296123693229E-18  -2.27922706264325E-01  -2.27903977286526E-01   0.00000000000000E+00  -1.31187065825171E-13
     -1.14528214312713E-22  -5.93180005295557E-11  -5.94491875954954E-11  -3.82659721917037E-18
      8.24128080169138E-07
      0.00000000000000E+00  -5.47394633756859E-14   0.00000000000000E+00   3.35427213677573E-17   6.30180482400598E-23
      5.47330337729098E-11   5.47330673156941E-11  -1.31608553431024E-18  -5.28137421164424E-03  -5.28137421165098E-03
      0.00000000000000E+00   0.00000000000000E+00   6.73442671624215E-12   0.00000000000000E+00   6.73442671624215E-12
      5.17663337051350E-18  -2.45156647378511E-01  -2.45137282663119E-01   0.00000000000000E+00  -1.26791707647722E-13
     -1.16142797252366E-22  -6.13407023241726E-11  -6.14674940319364E-11  -3.86054783620327E-18
      8.29128080169138E-07
      0.00000000000000E+00  -5.74948054919118E-14   0.00000000000000E+00   3.58180361634202E-17   7.18207609106740E-23
      5.74831922310577E-11   5.74832280491657E-11  -1.31551637114874E-18  -4.87260537110417E-03  -4.87260537111040E-03
      0.00000000000000E+00   0.00000000000000E+00   6.22937407067965E-12   0.00000000000000E+00   6.22937407067965E-12
      5.20778024086690E-18  -2.61549759803036E-01  -2.61529687903595E-01   0.00000000000000E+00  -1.22295713697296E-13
     -1.17663779196727E-22  -6.35903064060303E-11  -6.37126021198452E-11  -3.89226386971816E-18
      8.34128080169138E-07
      0.00000000000000E+00  -6.02501476081376E-14   0.00000000000000E+00   3.83086677663845E-17   7.77808435098686E-23
      6.02889845480844E-11   6.02890228568299E-11  -1.31474807498361E-18  -4.57826164501633E-03  -4.57826164502215E-03
      0.00000000000000E+00   0.00000000000000E+00   5.81916973718791E-12   0.00000000000000E+00   5.81916973718791E-12
      5.23687608955284E-18  -2.77135463912925E-01  -2.77114637426701E-01   0.00000000000000E+00  -1.17818231940366E-13
     -1.19104176860995E-22  -6.59903743619581E-11  -6.61081925940176E-11  -3.92212801456923E-18
      8.39128080169138E-07
      0.00000000000000E+00  -6.31891791987784E-14   0.00000000000000E+00   4.08768566539444E-17   8.20354098150581E-23
      6.31620909343815E-11   6.31621318113202E-11  -1.31381806055534E-18  -4.38136989848115E-03  -4.38136989848661E-03
      0.00000000000000E+00   0.00000000000000E+00   5.45869795110898E-12   0.00000000000000E+00   5.45869795110898E-12
      5.26416957930838E-18  -2.91955627086438E-01  -2.91934009143644E-01   0.00000000000000E+00  -1.13538238724708E-13
     -1.20473631626166E-22  -6.85072915235842E-11  -6.86208297624293E-11  -3.95035151875304E-18
      8.44128080169138E-07
      0.00000000000000E+00  -6.61282107894193E-14   0.00000000000000E+00   4.34618002503741E-17   8.53323629803305E-23
      6.61231298455629E-11   6.61231733074484E-11  -1.31273138520071E-18  -4.27791935621719E-03  -4.27791935622232E-03
      0.00000000000000E+00   0.00000000000000E+00   5.12517215993004E-12   0.00000000000000E+00   5.12517215993004E-12
      5.28979544010804E-18  -3.06061008991663E-01  -3.06038563405191E-01   0.00000000000000E+00  -1.09560132543690E-13
     -1.21779793858167E-22  -7.11387853347131E-11  -7.12483454673786E-11  -3.97706405490733E-18
      8.49128080169138E-07
      0.00000000000000E+00  -6.92509318544752E-14   0.00000000000000E+00   4.77890392814558E-17   8.81285528732566E-23
      6.92248916350100E-11   6.92249394241374E-11  -1.31145739318524E-18  -4.27847506988930E-03  -4.27847506989411E-03
      0.00000000000000E+00   0.00000000000000E+00   4.80916791915953E-12   0.00000000000000E+00   4.80916791915953E-12
      5.31384127970383E-18  -3.19529718681234E-01  -3.19506395602141E-01   0.00000000000000E+00  -1.06071773817692E-13
     -1.23030709622138E-22  -7.39280355693559E-11  -7.40341073432967E-11  -4.00238388651860E-18
      8.54128080169137E-07
      0.00000000000000E+00  -7.25573423939461E-14   0.00000000000000E+00   5.40853453553880E-17   9.07079711031806E-23
      7.25687808712478E-11   7.25688349566839E-11  -1.30991229807613E-18  -4.41815829124173E-03  -4.41815829124621E-03
      0.00000000000000E+00   0.00000000000000E+00   4.47379188834467E-12   0.00000000000000E+00   4.47379188834467E-12
      5.33621023914556E-18  -3.32397988718668E-01  -3.32373717975596E-01   0.00000000000000E+00  -1.02505534176073E-13
     -1.24226857592267E-22  -7.69401213107281E-11  -7.70426268450284E-11  -4.02629794106943E-18
      8.59128080169137E-07
      0.00000000000000E+00  -7.64148213566623E-14   0.00000000000000E+00   6.57607201682267E-17   9.33124446463454E-23
      7.63875758092079E-11   7.63876415700214E-11  -1.30789279561192E-18  -4.78532724581739E-03  -4.78532724582145E-03
      0.00000000000000E+00   0.00000000000000E+00   4.06142289390879E-12   0.00000000000000E+00   4.06142289390879E-12
      5.35651735361510E-18  -3.44665470075130E-01  -3.44640126317336E-01   0.00000000000000E+00  -9.80365755474935E-14
     -1.25358977287648E-22  -8.03510278882578E-11  -8.04490644639307E-11  -4.04862455800318E-18
      8.64128080169137E-07
      0.00000000000000E+00  -8.12825924286612E-14   0.00000000000000E+00   9.23677912043010E-17   9.63259485471039E-23
      8.12927192446803E-11   8.12928116125679E-11  -1.30488677341355E-18  -5.60187983492379E-03  -5.60187983492726E-03
      0.00000000000000E+00   0.00000000000000E+00   3.46356763164712E-12   0.00000000000000E+00   3.46356763164712E-12
      5.37383519177334E-18  -3.56340068717005E-01  -3.56313368149607E-01   0.00000000000000E+00  -9.14577284752954E-14
     -1.26404144753946E-22  -8.46649215156134E-11  -8.47563792442151E-11  -4.06894841835979E-18
      8.69128080169137E-07
      0.00000000000000E+00  -8.89975503540934E-14   0.00000000000000E+00   7.17389890713474E-17   1.00647284783678E-22
      8.90030324054747E-11   8.90031041445644E-11  -1.29955327132376E-18  -7.44688276342611E-03  -7.44688276342850E-03
      0.00000000000000E+00   0.00000000000000E+00   2.38382587730962E-12   0.00000000000000E+00   2.38382587730962E-12
      5.38575432115988E-18  -3.67432886930763E-01  -3.67404097654758E-01   0.00000000000000E+00  -7.91394110529805E-14
     -1.27300006446841E-22  -9.13077906106935E-11  -9.13869300218738E-11  -4.08620104983612E-18
      8.74128080169137E-07
      0.00000000000000E+00  -1.04519310942165E-13   0.00000000000000E+00   3.13598008657247E-16   1.08449949379222E-22
      1.04552180618909E-10   1.04552494217026E-10  -1.28848293335129E-18  -1.17778955831817E-02  -1.17778955831818E-02
      0.00000000000000E+00   0.00000000000000E+00   7.09135989974179E-14   0.00000000000000E+00   7.09135989974179E-14
      5.38610888915487E-18  -3.77938223855337E-01  -3.77905264898417E-01   0.00000000000000E+00  -5.28080550302215E-14
     -1.27887797679521E-22  -1.04570599760866E-10  -1.04623407816024E-10  -4.09762595580359E-18
      8.79128080169137E-07
      0.00000000000000E+00  -1.41716429511214E-13   0.00000000000000E+00   7.08725348377039E-16   1.23312744314453E-22
      1.41673237509325E-10   1.41673946234796E-10  -1.26494126177079E-18  -2.13887531399440E-02  -2.13887531399393E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.72147956800422E-12   0.00000000000000E+00  -4.72147956800422E-12
      5.36250149131485E-18  -3.87792871782285E-01  -3.87749728479794E-01   0.00000000000000E+00   5.56023191907125E-16
     -1.27865288857175E-22  -1.36953022689856E-10  -1.36952466666792E-10  -4.09756022954406E-18
      8.84128080169137E-07
      0.00000000000000E+00  -2.29519998281609E-13   0.00000000000000E+00   1.39700165176564E-15   1.45047575750750E-22
      2.29570966961673E-10   2.29572363963470E-10  -1.22324035712739E-18  -3.84029452848420E-02  -3.84029452848301E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.18582562282692E-11   0.00000000000000E+00  -1.18582562282692E-11
      5.30321021017351E-18  -3.96798369946258E-01  -3.96729784692192E-01   0.00000000000000E+00   7.08238959466808E-14
     -1.27041197447672E-22  -2.17784931631021E-10  -2.17714107735201E-10  -4.07996985304611E-18
      8.89128080169137E-07
      0.00000000000000E+00  -4.11923646375757E-13   0.00000000000000E+00   2.28191845850754E-15   1.65431513617492E-22
      4.11966056436434E-10   4.11968338355058E-10  -1.16812591644592E-18  -6.06999839483641E-02  -6.06999839483460E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.81361400265243E-11   0.00000000000000E+00  -1.81361400265243E-11
      5.21252951004088E-18  -4.04544121641578E-01  -4.04420054235421E-01   0.00000000000000E+00   1.15231944971482E-13
     -1.25701480772321E-22  -3.93947430273380E-10  -3.93832198328535E-10  -4.04440359359496E-18
      8.94128080169137E-07
      0.00000000000000E+00  -7.45411887176287E-13   0.00000000000000E+00   3.93898179424743E-15   1.80298382657497E-22
      7.45405256292308E-10   7.45409195274282E-10  -1.10963117838855E-18  -8.47216914300112E-02  -8.47216914299891E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.20862259047147E-11   0.00000000000000E+00  -2.20862259047147E-11
      5.10209838051731E-18  -4.10365003151143E-01  -4.10137136288573E-01   0.00000000000000E+00   1.27660291090249E-13
     -1.24191462400340E-22  -7.23450629660533E-10  -7.23322969369567E-10  -3.99246720212875E-18
      8.99128080169137E-07
      0.00000000000000E+00  -1.29289836567035E-12   0.00000000000000E+00   5.94002430517430E-15   1.91372038342948E-22
      1.29292718000192E-09   1.29293312002642E-09  -1.05438775978422E-18  -1.08501126221448E-01  -1.08501126221423E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.48378805374931E-11   0.00000000000000E+00  -2.48378805374931E-11
      4.97790897782984E-18  -4.13334917713589E-01  -4.12935429960990E-01   0.00000000000000E+00   1.31128826587982E-13
     -1.22604215268459E-22  -1.26822636831539E-09  -1.26809523948893E-09  -3.92352121804562E-18
      9.04128080169137E-07
      0.00000000000000E+00  -2.10967361365689E-12   0.00000000000000E+00   8.52778495505122E-15   2.00103364486147E-22
      2.10968437703083E-09   2.10969290481599E-09  -1.00464844136162E-18  -1.31397440417383E-01  -1.31397440417356E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75081108051102E-11   0.00000000000000E+00  -2.75081108051102E-11
      4.84036842380429E-18  -4.12315992121490E-01  -4.11660037759350E-01   0.00000000000000E+00   1.38934921893269E-13
     -1.20875555163074E-22  -2.08232372893265E-09  -2.08218479401088E-09  -3.83571998244268E-18
      9.09128080169137E-07
      0.00000000000000E+00  -3.22659746283762E-12   0.00000000000000E+00   1.14270915644160E-14   2.06435356785522E-22
      3.22654883299409E-09   3.22656026008586E-09  -9.60354454488693E-19  -1.53272754177111E-01  -1.53272754177081E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.03733189516709E-11   0.00000000000000E+00  -3.03733189516709E-11
      4.68850182904594E-18  -4.06078632081802E-01  -4.05071724582311E-01   0.00000000000000E+00   1.55657610995908E-13
     -1.18882593230622E-22  -3.19634259874506E-09  -3.19618694113419E-09  -3.72814737455724E-18
      9.14128080169137E-07
      0.00000000000000E+00  -4.64238408689165E-12   0.00000000000000E+00   1.43239870041701E-14   2.09688448426409E-22
      4.64233115723950E-09   4.64234548122671E-09  -9.20689277186679E-19  -1.74115589332525E-01  -1.74115589332492E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.32103955262784E-11   0.00000000000000E+00  -3.32103955262784E-11
      4.52244985141455E-18  -3.93454114704332E-01  -3.92002068688492E-01   0.00000000000000E+00   1.82192798290563E-13
     -1.16479744788817E-22  -4.60931727849861E-09  -4.60913508570043E-09  -3.60176057422787E-18
      9.19128080169137E-07
      0.00000000000000E+00  -6.33012297781716E-12   0.00000000000000E+00   1.69648073618574E-14   2.09366219563750E-22
      6.33008522957419E-09   6.33010219438176E-09  -8.84727861457891E-19  -1.93955667205577E-01  -1.93955667205542E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.57256449460311E-11   0.00000000000000E+00  -3.57256449460311E-11
      4.34382162668439E-18  -3.73452964427886E-01  -3.71469986515242E-01   0.00000000000000E+00   2.17393632799362E-13
     -1.13513352566436E-22  -6.29459394306842E-09  -6.29437654943573E-09  -3.45909376522650E-18
      9.24128080169137E-07
      0.00000000000000E+00  -8.24637157491500E-12   0.00000000000000E+00   1.91853774827241E-14   2.05649543673496E-22
      8.24631527300549E-09   8.24633445838318E-09  -8.51671833275063E-19  -2.12835954165904E-01  -2.12835954165866E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.77257660768211E-11   0.00000000000000E+00  -3.77257660768211E-11
      4.15519279630029E-18  -3.45338173427190E-01  -3.42752106638223E-01   0.00000000000000E+00   2.57338658492405E-13
     -1.09833669338378E-22  -8.20886603096474E-09  -8.20860869230636E-09  -3.30352096302522E-18
      9.29128080169137E-07
      0.00000000000000E+00  -1.03300531279422E-11   0.00000000000000E+00   2.08117273462113E-14   1.99554102119217E-22
      1.03300540794357E-08   1.03300748911633E-08  -8.20911133511800E-19  -2.30801705948205E-01  -2.30801705948166E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.92066294784709E-11   0.00000000000000E+00  -3.92066294784709E-11
      3.95915964890793E-18  -3.08705686371298E-01  -3.05463574151391E-01   0.00000000000000E+00   2.93126817281886E-13
     -1.05292909272554E-22  -1.02911613885020E-08  -1.02908682616848E-08  -3.13824851539613E-18
      9.34128080169137E-07
      0.00000000000000E+00  -1.24704028838264E-11   0.00000000000000E+00   2.13491449216705E-14   1.91806564259023E-22
      1.24704132846991E-08   1.24704346338442E-08  -7.92067228492558E-19  -2.47895688573495E-01  -2.47895688573454E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.05288001630594E-11   0.00000000000000E+00  -4.05288001630594E-11
      3.75651564809263E-18  -2.63710421756950E-01  -2.59794353784785E-01   0.00000000000000E+00   3.07949054056363E-13
     -9.97216684047207E-23  -1.24302137827351E-08  -1.24299058336811E-08  -2.96444841960008E-18
      9.39128080169137E-07
      0.00000000000000E+00  -1.44244915126537E-11   0.00000000000000E+00   1.94915364632387E-14   1.78873608849699E-22
      1.44244851933239E-08   1.44245046848605E-08  -7.65077931146371E-19  -2.64154559227431E-01  -2.64154559227389E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.26697178095990E-11   0.00000000000000E+00  -4.26697178095990E-11
      3.54316705904464E-18  -2.11637086978542E-01  -2.07105996518890E-01   0.00000000000000E+00   2.82209535227352E-13
     -9.32010026669976E-23  -1.43821171765860E-08  -1.43818349670509E-08  -2.77808912789827E-18
      9.44128080169137E-07
      0.00000000000000E+00  -1.58699439868258E-11   0.00000000000000E+00   1.44453181817485E-14   1.52495954645261E-22
      1.58699409476192E-08   1.58699553929375E-08  -7.40011052141405E-19  -2.79611963738620E-01  -2.79611963738574E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.59606273235044E-11   0.00000000000000E+00  -4.59606273235044E-11
      3.31336392242712E-18  -1.55200070676227E-01  -1.50214563435031E-01   0.00000000000000E+00   2.22558474001928E-13
     -8.69557969229890E-23  -1.58242173240879E-08  -1.58239947656140E-08  -2.57335287028571E-18
      9.49128080169137E-07
      0.00000000000000E+00  -1.65556567948172E-11   0.00000000000000E+00   6.93573555702077E-15   1.11886853866676E-22
      1.65557060463517E-08   1.65557129820873E-08  -7.16609928942549E-19  -2.94311019231784E-01  -2.94311019231736E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.81029696176037E-11   0.00000000000000E+00  -4.81029696176037E-11
      3.07284907433910E-18  -9.81653631081465E-02  -9.29644326682382E-02   0.00000000000000E+00   1.69009108048482E-13
     -8.03459556933095E-23  -1.65077790215777E-08  -1.65076100124697E-08  -2.35623914539655E-18
      9.54128080169136E-07
      0.00000000000000E+00  -1.51655866971812E-11   0.00000000000000E+00  -1.36746941930416E-14   6.06511775518132E-23
      1.51656372779368E-08   1.51656236032427E-08  -6.94184546361291E-19  -3.08305977890377E-01  -3.08305977890331E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.63231898409570E-11   0.00000000000000E+00  -4.63231898409570E-11
      2.84123312513431E-18  -5.03737446718953E-02  -4.56101907162851E-02   0.00000000000000E+00   1.30775035409599E-13
     -5.61574695267319E-23  -1.51194311884371E-08  -1.51193004134017E-08  -2.14704857877302E-18
      9.59128080169136E-07
      0.00000000000000E+00  -1.11288268074360E-11   0.00000000000000E+00  -3.96800783026738E-14   2.53477303651280E-23
      1.11288165445711E-08   1.11287768644929E-08  -6.69559419035257E-19  -3.21675263306706E-01  -3.21675263306671E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.49552232029429E-11   0.00000000000000E+00  -3.49552232029429E-11
      2.66645700911960E-18  -2.39078395653377E-02  -2.04125597088680E-02   0.00000000000000E+00   1.00381637457942E-13
     -2.78262701331484E-23  -1.10939220229273E-08  -1.10938216412899E-08  -1.99689759008434E-18
      9.64128080169136E-07
      0.00000000000000E+00  -8.05551821099776E-12   0.00000000000000E+00  -3.01559114397475E-14   1.33325221218920E-23
      8.05552143859579E-09   8.05549128268437E-09  -6.42514598658509E-19  -3.34445266785059E-01  -3.34445266785035E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40743062322374E-11   0.00000000000000E+00  -2.40743062322374E-11
      2.54608547795841E-18  -1.32014377647359E-02  -1.06710114892186E-02   0.00000000000000E+00   6.14716874195580E-14
     -1.38281213121574E-23  -8.03147844813953E-09  -8.03141697645212E-09  -1.90357087929990E-18
      9.69128080169136E-07
      0.00000000000000E+00  -6.75472119792755E-12   0.00000000000000E+00  -1.26774963762682E-14   8.37264504638995E-24
      6.75469309261888E-09   6.75468041512251E-09  -6.14875174103773E-19  -3.46615502737635E-01  -3.46615502737616E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.88625412808598E-11   0.00000000000000E+00  -1.88625412808598E-11
      2.45177277155411E-18  -9.13399053374199E-03  -7.01176108142644E-03   0.00000000000000E+00   3.29873772592089E-14
     -9.16386523368356E-24  -6.73585086121890E-09  -6.73581787384165E-09  -1.83689759745034E-18
      9.74128080169136E-07
      0.00000000000000E+00  -6.31487675144071E-12   0.00000000000000E+00  -4.19434617796539E-15   6.11083459061171E-24
      6.31491775493498E-09   6.31491356058881E-09  -5.87615273628154E-19  -3.58195410298997E-01  -3.58195410298981E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66805106965945E-11   0.00000000000000E+00  -1.66805106965945E-11
      2.36837021807114E-18  -7.32619340429512E-03  -5.34183044058352E-03   0.00000000000000E+00   2.01644606752341E-14
     -7.16620498298606E-24  -6.29825321435288E-09  -6.29823304989221E-09  -1.78075494444299E-18
      9.79128080169136E-07
      0.00000000000000E+00  -6.16599643242731E-12   0.00000000000000E+00  -1.34211772953332E-15   4.85094737518481E-24
      6.16604135185395E-09   6.16604000973623E-09  -5.61135632928245E-19  -3.69195642805913E-01  -3.69195642805897E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55790430390416E-11   0.00000000000000E+00  -1.55790430390416E-11
      2.29047500287593E-18  -6.29977555840554E-03  -4.36196916866197E-03   0.00000000000000E+00   1.49912125713129E-14
     -5.89951245379996E-24  -6.15047595790975E-09  -6.15046096669719E-09  -1.72933936994769E-18
      9.84128080169136E-07
      0.00000000000000E+00  -6.10400123481223E-12   0.00000000000000E+00  -4.98506791904085E-16   4.01497440760321E-24
      6.10397901304011E-09   6.10397851453333E-09  -5.35691545645223E-19  -3.79606808844064E-01  -3.79606808844049E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48178440003230E-11   0.00000000000000E+00  -1.48178440003230E-11
      2.21638578287432E-18  -5.60953904995239E-03  -3.69104506887643E-03   0.00000000000000E+00   1.24560603996237E-14
     -5.00729609273760E-24  -6.08917312659340E-09  -6.08916067053301E-09  -1.68069423722909E-18
      9.89128080169136E-07
      0.00000000000000E+00  -6.06937576888499E-12   0.00000000000000E+00  -2.39983033049278E-16   3.42215761798113E-24
      6.06936831418639E-09   6.06936807420336E-09  -5.11627686270144E-19  -3.89354948292051E-01  -3.89354948292037E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40746468080436E-11   0.00000000000000E+00  -1.40746468080436E-11
      2.14601254883410E-18  -5.11046545992961E-03  -3.20264081328340E-03   0.00000000000000E+00   1.07153439037934E-14
     -4.34375845647639E-24  -6.05530414273922E-09  -6.05529342739532E-09  -1.63438486256396E-18
      9.94128080169136E-07
      0.00000000000000E+00  -6.04503691352500E-12   0.00000000000000E+00  -1.50935226775532E-16   2.99322558479177E-24
      6.04505512361503E-09   6.04505497267980E-09  -4.89610556054360E-19  -3.98220653920528E-01  -3.98220653920515E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30396534130580E-11   0.00000000000000E+00  -1.30396534130580E-11
      2.08081428176881E-18  -4.74378018931951E-03  -2.84328875810650E-03   0.00000000000000E+00   9.12634245885566E-15
     -3.85060317791545E-24  -6.03202444560920E-09  -6.03201531926674E-09  -1.59120372571445E-18
      9.99128080169136E-07
      0.00000000000000E+00  -6.02473922660213E-12   0.00000000000000E+00  -1.16917621417208E-15   2.68710547085203E-24
      6.02473423798859E-09   6.02473306881238E-09  -4.70818004004221E-19  -4.05765965997383E-01  -4.05765965997371E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13131440214440E-11   0.00000000000000E+00  -1.13131440214440E-11
      2.02424856166159E-18  -4.48124342166956E-03  -2.58660969387536E-03   0.00000000000000E+00   8.40318612981753E-15
     -3.50196570464999E-24  -6.01342832797706E-09  -6.01341992479093E-09  -1.55343055765737E-18
      1.00412808016914E-06
      0.00000000000000E+00  -6.00499260810251E-12   0.00000000000000E+00  -8.84664271938628E-17   2.48260846367426E-24
      6.00495852455512E-09   6.00495843608869E-09  -4.57033659085175E-19  -4.11295753542365E-01  -4.11295753542356E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.43205369024454E-12   0.00000000000000E+00  -8.43205369024454E-12
      1.98208829321037E-18  -4.30999920616168E-03  -2.42068789088370E-03   0.00000000000000E+00   5.17805851623126E-15
     -3.29017697805386E-24  -5.99653156045696E-09  -5.99652638239844E-09  -1.52505463412519E-18
      1.00912808016914E-06
      0.00000000000000E+00  -5.98285802643550E-12   0.00000000000000E+00  -1.94612363572037E-16   2.37203517730733E-24
      5.98287757544381E-09   5.98287738083145E-09  -4.50650482413365E-19  -4.13856544139097E-01  -4.13856544139093E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.95160978819951E-12   0.00000000000000E+00  -3.95160978819951E-12
      1.96233024426937E-18  -4.22917394978733E-03  -2.34540775522826E-03   0.00000000000000E+00   2.46666867554037E-15
     -3.22639249039911E-24  -5.97892823771192E-09  -5.97892577104325E-09  -1.51167976185600E-18
      1.01412808016914E-06
      0.00000000000000E+00  -5.95502907106162E-12   0.00000000000000E+00  -2.88270942873081E-16   2.36065937981342E-24
      5.95506190835643E-09   5.95506162008549E-09  -4.54547418477328E-19  -4.12292852781784E-01  -4.12292852781786E-01
      0.00000000000000E+00   0.00000000000000E+00   2.40033095798732E-12   0.00000000000000E+00   2.40033095798732E-12
      1.97433189905931E-18  -4.25292224598133E-03  -2.37591874741436E-03   0.00000000000000E+00  -1.17041593899465E-15
     -3.35262841885037E-24  -5.95746078062753E-09  -5.95746195104347E-09  -1.51978448058198E-18
      1.01912808016914E-06
      0.00000000000000E+00  -5.91571952353680E-12   0.00000000000000E+00  -4.38010056738376E-16   2.47146792958074E-24
      5.91574555377022E-09   5.91574511576016E-09  -4.71794616763097E-19  -4.05374440088111E-01  -4.05374440088122E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05294005651794E-11   0.00000000000000E+00   1.05294005651794E-11
      2.02697890188520E-18  -4.42242812152371E-03  -2.55525143185988E-03   0.00000000000000E+00  -6.00626780730257E-15
     -3.77652993720278E-24  -5.92626851005753E-09  -5.92627451632534E-09  -1.55518428512211E-18
      1.02412808016914E-06
      0.00000000000000E+00  -5.85216296538919E-12   0.00000000000000E+00  -7.56480417753785E-16   2.75753169573094E-24
      5.85220210268586E-09   5.85220134620545E-09  -5.05213095467420E-19  -3.91947739573832E-01  -3.91947739573852E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99114465661346E-11   0.00000000000000E+00   1.99114465661346E-11
      2.12653613471588E-18  -4.83973044957604E-03  -2.98961970570250E-03   0.00000000000000E+00  -1.24801468794065E-14
     -4.77154956195505E-24  -5.87210031262469E-09  -5.87211279277157E-09  -1.62132303924846E-18
      1.02912808016914E-06
      0.00000000000000E+00  -5.73129529122408E-12   0.00000000000000E+00  -1.41308591409706E-15   3.32473309841626E-24
      5.73123075378990E-09   5.73122934070398E-09  -5.56716113983441E-19  -3.71048549009396E-01  -3.71048549009426E-01
      0.00000000000000E+00   0.00000000000000E+00   2.98527742042090E-11   0.00000000000000E+00   2.98527742042090E-11
      2.27580000573692E-18  -5.76281152095402E-03  -3.94768520266198E-03   0.00000000000000E+00  -2.14188077628258E-14
     -7.07486118296957E-24  -5.76106069610043E-09  -5.76108211490820E-09  -1.71908389175348E-18
      1.03412808016914E-06
      0.00000000000000E+00  -5.46191467699441E-12   0.00000000000000E+00  -4.36247481754203E-15   4.34655044505425E-24
      5.46190452058827E-09   5.46190015811346E-09  -6.26146881381931E-19  -3.41972130261945E-01  -3.41972130261985E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03017608616177E-11   0.00000000000000E+00   4.03017608616177E-11
      2.47730881004501E-18  -7.86893889003679E-03  -6.13538023668192E-03   0.00000000000000E+00  -3.26123036415793E-14
     -1.27087778310189E-23  -5.50216930667144E-09  -5.50220191897509E-09  -1.85116192866308E-18
      1.03912808016914E-06
      0.00000000000000E+00  -4.82570618235787E-12   0.00000000000000E+00  -6.77191153288999E-15   5.90635170043681E-24
      4.82572012597733E-09   4.82571335406580E-09  -7.09983671765317E-19  -3.04360626475088E-01  -3.04360626475141E-01
      0.00000000000000E+00   0.00000000000000E+00   5.30744336700591E-11   0.00000000000000E+00   5.30744336700591E-11
      2.74268097839531E-18  -1.28308986699855E-02  -1.12937619932559E-02   0.00000000000000E+00  -5.16131988616220E-14
     -2.62105652655754E-23  -4.87873617453697E-09  -4.87878778773586E-09  -2.03269730662999E-18
      1.04412808016914E-06
      0.00000000000000E+00  -3.53381810879680E-12   0.00000000000000E+00  -1.33558232147351E-14   6.84067171692345E-24
      3.53388267314982E-09   3.53386931732661E-09  -8.02943905579976E-19  -2.58458139580620E-01  -2.58458139580690E-01
      0.00000000000000E+00   0.00000000000000E+00   6.99426118052420E-11   0.00000000000000E+00   6.99426118052420E-11
      3.09239403742151E-18  -2.36027023836418E-02  -2.24672715983706E-02   0.00000000000000E+00  -7.72997640148732E-14
     -5.10756196204183E-23  -3.60373462936779E-09  -3.60381192913185E-09  -2.28945013184154E-18
      1.04912808016914E-06
      0.00000000000000E+00  -1.85315126263627E-12   0.00000000000000E+00  -1.74727066207373E-14   2.02781037243692E-24
      1.85321956295091E-09   1.85320209024429E-09  -9.03407268355347E-19  -2.05715158296919E-01  -2.05715158297003E-01
      0.00000000000000E+00   0.00000000000000E+00   8.47534231678059E-11   0.00000000000000E+00   8.47534231678059E-11
      3.51616115326054E-18  -4.17596189430323E-02  -4.11490431984286E-02   0.00000000000000E+00  -1.18250803693616E-13
     -7.61503802791748E-23  -1.93783726260833E-09  -1.93795551341210E-09  -2.61275388490520E-18
      1.05412808016914E-06
      0.00000000000000E+00  -6.83967757984452E-13   0.00000000000000E+00  -1.26179891704339E-14  -1.17994356748275E-23
      6.83980996633088E-10   6.83968378643906E-10  -1.01334208267207E-18  -1.48958623935233E-01  -1.48958623935321E-01
      0.00000000000000E+00   0.00000000000000E+00   8.84753503522778E-11   0.00000000000000E+00   8.84753503522778E-11
      3.95853790502193E-18  -6.45739221945080E-02  -6.43305566970197E-02   0.00000000000000E+00  -1.79006176154729E-13
     -8.84504066453329E-23  -7.72264722819941E-10  -7.72443728996184E-10  -2.94519582234986E-18
      1.05912808016914E-06
      0.00000000000000E+00  -1.93516861296259E-13   0.00000000000000E+00  -6.17141697325253E-15  -2.72077651211531E-23
      1.93601310643670E-10   1.93595139226670E-10  -1.13028752204894E-18  -9.22166422525697E-02  -9.22166422526508E-02
      0.00000000000000E+00   0.00000000000000E+00   8.10516184418781E-11   0.00000000000000E+00   8.10516184418781E-11
      4.36379599723132E-18  -8.86549294165318E-02  -8.85684001609544E-02   0.00000000000000E+00  -2.53344534657383E-13
     -9.48228812314764E-23  -2.74393413133795E-10  -2.74646757668547E-10  -3.23350847518239E-18
      1.06412808016914E-06
      0.00000000000000E+00  -5.74948054919118E-14   0.00000000000000E+00  -2.62673383801061E-15  -3.47609890487439E-23
      5.75243494379593E-11   5.75217227040866E-11  -1.22926463932848E-18  -4.64042448541634E-02  -4.64042448542255E-02
      0.00000000000000E+00   0.00000000000000E+00   6.20974731693532E-11   0.00000000000000E+00   6.20974731693532E-11
      4.67428336307809E-18  -1.12314699884070E-01  -1.12277013289004E-01   0.00000000000000E+00  -2.89959074014159E-13
     -1.00536237696814E-22  -1.19329236799325E-10  -1.19619195873440E-10  -3.44501872374961E-18
      1.06912808016914E-06
      0.00000000000000E+00  -3.73808080434634E-14   0.00000000000000E+00  -8.34789540027423E-16  -3.29786247990963E-23
      3.73617602616032E-11   3.73609254720302E-11  -1.28349900463545E-18  -2.21662974254354E-02  -2.21662974254727E-02
      0.00000000000000E+00   0.00000000000000E+00   3.72873815026683E-11   0.00000000000000E+00   3.72873815026683E-11
      4.86072027059143E-18  -1.35049091716320E-01  -1.35025573597879E-01   0.00000000000000E+00  -2.33631633907487E-13
     -1.04645296210530E-22  -7.44146753406863E-11  -7.46483069746984E-11  -3.57722126595598E-18
      1.07412808016914E-06
      0.00000000000000E+00  -3.95850817364440E-14   0.00000000000000E+00  -1.76992104918475E-16  -2.29171524112936E-23
      3.95581539444288E-11   3.95579769523009E-11  -1.30553353405350E-18  -1.25479389429970E-02  -1.25479389430178E-02
      0.00000000000000E+00   0.00000000000000E+00   2.08632816290318E-11   0.00000000000000E+00   2.08632816290318E-11
      4.96503667873659E-18  -1.56754922169145E-01  -1.56735886481781E-01   0.00000000000000E+00  -1.73917153230865E-13
     -1.07418138269508E-22  -6.02473414279944E-11  -6.04212585813327E-11  -3.65950314468309E-18
      1.07912808016914E-06
      0.00000000000000E+00  -4.37180949107827E-14   0.00000000000000E+00  -6.93672061490353E-20  -4.60114639099382E-24
      4.36834184394557E-11   4.36834183700839E-11  -1.31334453530445E-18  -8.86664573510648E-03  -8.86664573511958E-03
      0.00000000000000E+00   0.00000000000000E+00   1.30994307132571E-11   0.00000000000000E+00   1.30994307132571E-11
      5.03053383230288E-18  -1.77431120582357E-01  -1.77413231312267E-01   0.00000000000000E+00  -1.47819379389151E-13
     -1.09622557336815E-22  -5.66350297038420E-11  -5.67828490833408E-11  -3.71718929699842E-18
      1.08412808016914E-06
      0.00000000000000E+00  -4.71163501874612E-14   0.00000000000000E+00   3.08561817281388E-17   1.81754866294964E-23
      4.71243852461592E-11   4.71244161023591E-11  -1.31592252953318E-18  -7.18744133898577E-03  -7.18744133899545E-03
      0.00000000000000E+00   0.00000000000000E+00   9.67924225014927E-12   0.00000000000000E+00   9.67924225014927E-12
      5.07893004355362E-18  -1.97111020326983E-01  -1.97093124619884E-01   0.00000000000000E+00  -1.38592965248228E-13
     -1.11583291630504E-22  -5.66650653871488E-11  -5.68036583525086E-11  -3.76300751402044E-18
      1.08912808016914E-06
      0.00000000000000E+00  -5.00553817781021E-14   0.00000000000000E+00   3.28454276417617E-17   3.91210242954058E-23
      5.00588069890768E-11   5.00588398345435E-11  -1.31661515511684E-18  -6.21099513529579E-03  -6.21099513530384E-03
      0.00000000000000E+00   0.00000000000000E+00   8.04356939227583E-12   0.00000000000000E+00   8.04356939227583E-12
      5.11914789051500E-18  -2.15838512338629E-01  -2.15820207579190E-01   0.00000000000000E+00  -1.33838869919553E-13
     -1.13391345127367E-22  -5.79685703567862E-11  -5.81024092268192E-11  -3.80253273539816E-18
      1.09412808016914E-06
      0.00000000000000E+00  -5.28107238943279E-14   0.00000000000000E+00   3.32151693451097E-17   5.53467013301928E-23
      5.28111204095515E-11   5.28111536247762E-11  -1.31654569623104E-18  -5.54648592418071E-03  -5.54648592418784E-03
      0.00000000000000E+00   0.00000000000000E+00   7.12904843018132E-12   0.00000000000000E+00   7.12904843018132E-12
      5.15479313266591E-18  -2.33658732965724E-01  -2.33639849334594E-01   0.00000000000000E+00  -1.29605926067989E-13
     -1.15075839063811E-22  -5.98105961287745E-11  -5.99402020549575E-11  -3.83824743643487E-18
      1.09912808016914E-06
      0.00000000000000E+00  -5.55660660105537E-14   0.00000000000000E+00   3.48457871667138E-17   6.66551802400460E-23
      5.55462744705550E-11   5.55463093164089E-11  -1.31609872787765E-18  -5.06408541520436E-03  -5.06408541521088E-03
      0.00000000000000E+00   0.00000000000000E+00   6.52714388240044E-12   0.00000000000000E+00   6.52714388240044E-12
      5.18742885207791E-18  -2.50613697652074E-01  -2.50594142072442E-01   0.00000000000000E+00  -1.25220995849909E-13
     -1.16656251225996E-22  -6.19482322028430E-11  -6.20734531988096E-11  -3.87133012420026E-18
      1.10412808016914E-06
      0.00000000000000E+00  -5.83214081267795E-14   0.00000000000000E+00   3.70876330938946E-17   7.42413392927076E-23
      5.83220710023754E-11   5.83221080900827E-11  -1.31542086488688E-18  -4.70987032268691E-03  -4.70987032269299E-03
      0.00000000000000E+00   0.00000000000000E+00   6.07109403346724E-12   0.00000000000000E+00   6.07109403346724E-12
      5.21778432224525E-18  -2.66738931345061E-01  -2.66718645068109E-01   0.00000000000000E+00  -1.20747668660048E-13
     -1.18148423622342E-22  -6.42724544547717E-11  -6.43932021235499E-11  -3.90236345735837E-18
      1.10912808016914E-06
      0.00000000000000E+00  -6.11685949802128E-14   0.00000000000000E+00   3.94336484561658E-17   7.94474016807281E-23
      6.11542396773956E-11   6.11542791111235E-11  -1.31457402464693E-18  -4.45770585993969E-03  -4.45770585994538E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68691690353445E-12   0.00000000000000E+00   5.68691690353445E-12
      5.24621890676292E-18  -2.82069032561922E-01  -2.82047975190446E-01   0.00000000000000E+00  -1.16341419959896E-13
     -1.19563874365541E-22  -6.67248545945780E-11  -6.68411960146574E-11  -3.93164488211599E-18
      1.11412808016913E-06
      0.00000000000000E+00  -6.40157818336462E-14   0.00000000000000E+00   4.15913107171204E-17   8.32665878562121E-23
      6.40540488413035E-11   6.40540904326974E-11  -1.31358099272682E-18  -4.29608169339771E-03  -4.29608169340306E-03
      0.00000000000000E+00   0.00000000000000E+00   5.34151111573714E-12   0.00000000000000E+00   5.34151111573714E-12
      5.27292646234161E-18  -2.96648338033032E-01  -2.96626476047474E-01   0.00000000000000E+00  -1.12170324419297E-13
     -1.20911364974553E-22  -6.92834312238949E-11  -6.93956015484351E-11  -3.95934546961479E-18
      1.11912808016913E-06
      0.00000000000000E+00  -6.70466581614945E-14   0.00000000000000E+00   4.48904636523841E-17   8.63230675960358E-23
      6.70485691576098E-11   6.70486140481598E-11  -1.31243549332651E-18  -4.22548000373035E-03  -4.22548000373537E-03
      0.00000000000000E+00   0.00000000000000E+00   5.01880942787191E-12   0.00000000000000E+00   5.01880942787191E-12
      5.29802050948096E-18  -3.10535802009932E-01  -3.10513098423986E-01   0.00000000000000E+00  -1.08367140770941E-13
     -1.22198575762987E-22  -7.19590563351385E-11  -7.20674234760317E-11  -3.98558501615445E-18
      1.12412808016913E-06
      0.00000000000000E+00  -7.01693792265504E-14   0.00000000000000E+00   4.92212723040420E-17   8.89946675351293E-23
      7.02011138713000E-11   7.02011630926613E-11  -1.31109395300295E-18  -4.26214137097348E-03  -4.26214137097819E-03
      0.00000000000000E+00   0.00000000000000E+00   4.70666219536045E-12   0.00000000000000E+00   4.70666219536045E-12
      5.32155382045776E-18  -3.23806809694491E-01  -3.23783211403666E-01   0.00000000000000E+00  -1.04996899038561E-13
     -1.23432468174393E-22  -7.48028283888596E-11  -7.49078252880216E-11  -4.01045986745482E-18
      1.12912808016913E-06
      0.00000000000000E+00  -7.36594792404365E-14   0.00000000000000E+00   5.63805023258216E-17   9.15260031476234E-23
      7.36338337610512E-11   7.36338901416450E-11  -1.30945035114637E-18  -4.45150288099900E-03  -4.45150288100336E-03
      0.00000000000000E+00   0.00000000000000E+00   4.35962987346331E-12   0.00000000000000E+00   4.35962987346331E-12
      5.34335196982509E-18  -3.36478470835947E-01  -3.36453900570089E-01   0.00000000000000E+00  -1.01283549301702E-13
     -1.24610274267040E-22  -7.78922364656821E-11  -7.79935200151085E-11  -4.03390161867871E-18
      1.13412808016913E-06
      0.00000000000000E+00  -7.76088029403601E-14   0.00000000000000E+00   7.03857786932223E-17   9.41675637212422E-23
      7.76446865294118E-11   7.76447569152847E-11  -1.30724607445164E-18  -4.90590907487198E-03  -4.90590907487590E-03
      0.00000000000000E+00   0.00000000000000E+00   3.91569857588490E-12   0.00000000000000E+00   3.91569857588490E-12
      5.36293046270451E-18  -3.48551245244993E-01  -3.48525551404709E-01   0.00000000000000E+00  -9.64474309730211E-14
     -1.25720245405548E-22  -8.14640080600706E-11  -8.15604554911693E-11  -4.05568438825287E-18
      1.13912808016913E-06
      0.00000000000000E+00  -8.30276424356042E-14   0.00000000000000E+00   1.02161696586520E-16   9.73866979942907E-23
      8.30324368133901E-11   8.30325389751841E-11  -1.30382185049464E-18  -5.91080703590014E-03  -5.91080703590337E-03
      0.00000000000000E+00   0.00000000000000E+00   3.23451473488399E-12   0.00000000000000E+00   3.23451473488399E-12
      5.37910303637893E-18  -3.60035837519739E-01  -3.60008661086600E-01   0.00000000000000E+00  -8.88987498203902E-14
     -1.26732692933445E-22  -8.61781549601211E-11  -8.62670537100683E-11  -4.07528118588429E-18
      1.14412808016913E-06
      0.00000000000000E+00  -9.21202714191493E-14   0.00000000000000E+00   1.91502702582132E-16   1.02335515994265E-22
      9.20900797038932E-11   9.20902712066981E-11  -1.29743860910771E-18  -8.21609205667871E-03  -8.21609205668063E-03
      0.00000000000000E+00   0.00000000000000E+00   1.92786127025053E-12   0.00000000000000E+00   1.92786127025053E-12
      5.38874234273018E-18  -3.70941463447945E-01  -3.70911845343285E-01   0.00000000000000E+00  -7.40740739907582E-14
     -1.27566467919538E-22  -9.39440584028303E-11  -9.40181324769486E-11  -4.09130373362247E-18
      1.14912808016913E-06
      0.00000000000000E+00  -1.11499510969937E-13   0.00000000000000E+00   3.87672957953750E-16   1.11679593565771E-22
      1.11516498844251E-10   1.11516886517321E-10  -1.28382180019900E-18  -1.36399986449741E-02  -1.36399986449732E-02
      0.00000000000000E+00   0.00000000000000E+00  -9.28846869567542E-13   0.00000000000000E+00  -9.28846869567542E-13
      5.38409810838234E-18  -3.81252389190248E-01  -3.81217551265527E-01   0.00000000000000E+00  -4.13217548570736E-14
     -1.28021792127745E-22  -1.10546717892768E-10  -1.10588039647753E-10  -4.10027630818334E-18
      1.15412808016913E-06
      0.00000000000000E+00  -1.58799550631814E-13   0.00000000000000E+00   8.46658487143955E-16   1.28850609380956E-22
      1.58792608435227E-10   1.58793455093843E-10  -1.25560483060406E-18  -2.51931940491753E-02  -2.51931940491688E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.52836829948365E-12   0.00000000000000E+00  -6.52836829948365E-12
      5.35145626688492E-18  -3.90877505225969E-01  -3.90829538089272E-01   0.00000000000000E+00   1.98946499634898E-14
     -1.27779395679964E-22  -1.52284981444195E-10  -1.52265086794359E-10  -4.09585143628086E-18
      1.15912808016913E-06
      0.00000000000000E+00  -2.67543719485525E-13   0.00000000000000E+00   1.76908082734880E-15   1.51188612173098E-22
      2.67537085283093E-10   2.67538854364071E-10  -1.20930349234811E-18  -4.40291985970931E-02  -4.40291985970793E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.38048508979764E-11   0.00000000000000E+00  -1.38048508979764E-11
      5.28243201239504E-18  -3.99566412910019E-01  -3.99486480478375E-01   0.00000000000000E+00   8.72572613779965E-14
     -1.26766114615174E-22  -2.53821260727346E-10  -2.53734003466095E-10  -4.07312852004693E-18
      1.16412808016913E-06
      0.00000000000000E+00  -4.84940212455741E-13   0.00000000000000E+00   2.77379561981105E-15   1.70123680345341E-22
      4.84963673568786E-10   4.84966447364576E-10  -1.15229703153524E-18  -6.71120724901009E-02  -6.71120724900815E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.94335000906479E-11   0.00000000000000E+00  -1.94335000906479E-11
      5.18526451194180E-18  -4.06841942765044E-01  -4.06695287598741E-01   0.00000000000000E+00   1.21192187780656E-13
     -1.25351504144325E-22  -4.65654139461583E-10  -4.65532947273928E-10  -4.03296748040655E-18
      1.16912808016913E-06
      0.00000000000000E+00  -8.70504419252939E-13   0.00000000000000E+00   4.39127665543141E-15   1.83730682292599E-22
      8.70492773110488E-10   8.70497164387327E-10  -1.09421359109887E-18  -9.12004567010355E-02  -9.12004567010126E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.29089129742551E-11   0.00000000000000E+00  -2.29089129742551E-11
      5.07071994707053E-18  -4.11966512573765E-01  -4.11699498273583E-01   0.00000000000000E+00   1.29173372576001E-13
     -1.23816358406557E-22  -8.47717424785524E-10  -8.47588251413072E-10  -3.97650635597165E-18
      1.17412808016913E-06
      0.00000000000000E+00  -1.48650707170382E-12   0.00000000000000E+00   6.59695813379909E-15   1.94088842246305E-22
      1.48651728368969E-09   1.48652388064802E-09  -1.04036885494744E-18  -1.14773976702827E-01  -1.14773976702801E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.55565587574650E-11   0.00000000000000E+00  -2.55565587574650E-11
      4.94293715328320E-18  -4.13948909024495E-01  -4.13488660117440E-01   0.00000000000000E+00   1.32820407127217E-13
     -1.22197895825887E-22  -1.46110014229755E-09  -1.46096732189055E-09  -3.90256829833576E-18
      1.17912808016913E-06
      0.00000000000000E+00  -2.38318724106090E-12   0.00000000000000E+00   9.29920080817558E-15   2.02217148714613E-22
      2.38321558069182E-09   2.38322487989283E-09  -9.92157123628476E-19  -1.37401344064993E-01  -1.37401344064965E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.82829412413012E-11   0.00000000000000E+00  -2.82829412413012E-11
      4.80152244707670E-18  -4.11611569181931E-01  -4.10869686404693E-01   0.00000000000000E+00   1.42794608978512E-13
     -1.20408418620405E-22  -2.35508473326038E-09  -2.35494193865152E-09  -3.80936532344822E-18
      1.18412808016913E-06
      0.00000000000000E+00  -3.58277135372841E-12   0.00000000000000E+00   1.22280925069448E-14   2.07780185160584E-22
      3.58279914128276E-09   3.58281136937548E-09  -9.49208294984544E-19  -1.58997073762406E-01  -1.58997073762375E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.11703266488289E-11   0.00000000000000E+00  -3.11703266488289E-11
      4.64567081383255E-18  -4.03726841387400E-01  -4.02607951579575E-01   0.00000000000000E+00   1.62152192322653E-13
     -1.18317031731441E-22  -3.55180319491886E-09  -3.55164104272665E-09  -3.69646251884801E-18
      1.18912808016913E-06
      0.00000000000000E+00  -5.07607493598559E-12   0.00000000000000E+00   1.50783527475697E-14   2.10084225021790E-22
      5.07608897671286E-09   5.07610405506581E-09  -9.10634340340504E-19  -1.79565676969588E-01  -1.79565676969554E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.39468365032882E-11   0.00000000000000E+00  -3.39468365032882E-11
      4.47593663131611E-18  -3.89165189895079E-01  -3.87576722355344E-01   0.00000000000000E+00   1.91236154015946E-13
     -1.15774482053854E-22  -5.04234845471642E-09  -5.04215721856252E-09  -3.56530229097560E-18
      1.19412808016913E-06
      0.00000000000000E+00  -6.83086048507259E-12   0.00000000000000E+00   1.76163230500190E-14   2.08772783528881E-22
      6.83088409491090E-09   6.83090171123416E-09  -8.75531691281079E-19  -1.99142375614988E-01  -1.99142375614951E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.63356008738231E-11   0.00000000000000E+00  -3.63356008738231E-11
      4.29425862694700E-18  -3.66999721929703E-01  -3.64859158416348E-01   0.00000000000000E+00   2.28270570200132E-13
     -1.12627159758966E-22  -6.79479438093042E-09  -6.79456611036033E-09  -3.41872693566591E-18
      1.19912808016913E-06
      0.00000000000000E+00  -8.79982796132755E-12   0.00000000000000E+00   1.96978106730168E-14   2.04264472203092E-22
      8.79983997553148E-09   8.79985967334235E-09  -8.43149666951587E-19  -2.17771489706177E-01  -2.17771489706138E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.81844139932943E-11   0.00000000000000E+00  -3.81844139932943E-11
      4.10333655698053E-18  -3.36573227471589E-01  -3.33812911474535E-01   0.00000000000000E+00   2.68287427328052E-13
     -1.08727470177030E-22  -8.76194354677628E-09  -8.76167525934906E-09  -3.26018689002894E-18
      1.20412808016913E-06
      0.00000000000000E+00  -1.09139101223704E-11   0.00000000000000E+00   2.11045132773929E-14   1.97706984409932E-22
      1.09138742758390E-08   1.09138953803525E-08  -8.12934401159912E-19  -2.35498003125891E-01  -2.35498003125851E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.95624761791088E-11   0.00000000000000E+00  -3.95624761791088E-11
      3.90552417608498E-18  -2.97599176402011E-01  -2.94173232024208E-01   0.00000000000000E+00   3.00463831014182E-13
     -1.03923047603049E-22  -1.08746333680043E-08  -1.08743329041734E-08  -3.09258977492507E-18
      1.20912808016913E-06
      0.00000000000000E+00  -1.30359827755503E-11   0.00000000000000E+00   2.11632289021688E-14   1.89213570111222E-22
      1.30359238685852E-08   1.30359450318143E-08  -7.84583907534094E-19  -2.52363378389183E-01  -2.52363378389142E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.09792306578433E-11   0.00000000000000E+00  -4.09792306578433E-11
      3.70062802279576E-18  -2.50464834476762E-01  -2.46370727238362E-01   0.00000000000000E+00   3.06019690101897E-13
     -9.80549181189819E-23  -1.29952718208465E-08  -1.29949658011565E-08  -2.91604411526167E-18
      1.21412808016913E-06
      0.00000000000000E+00  -1.48804087881519E-11   0.00000000000000E+00   1.84039271177399E-14   1.73364597169789E-22
      1.48803105923247E-08   1.48803289962520E-08  -7.58118716980885E-19  -2.68402454218309E-01  -2.68402454218266E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.35129435815379E-11   0.00000000000000E+00  -4.35129435815379E-11
      3.48306330488807E-18  -1.96868270790954E-01  -1.92193820315262E-01   0.00000000000000E+00   2.68318175082344E-13
     -9.14182814613394E-23  -1.48370843708455E-08  -1.48368160526705E-08  -2.72494458790719E-18
      1.21912808016913E-06
      0.00000000000000E+00  -1.61553974300667E-11   0.00000000000000E+00   1.27655919243506E-14   1.43062214181243E-22
      1.61554033155075E-08   1.61554160810995E-08  -7.33530393368855E-19  -2.83650706205103E-01  -2.83650706205056E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.67353335815347E-11   0.00000000000000E+00  -4.67353335815347E-11
      3.24938663698040E-18  -1.39776024154629E-01  -1.34700811269656E-01   0.00000000000000E+00   2.06624955071120E-13
     -8.55488035421348E-23  -1.61088873724730E-08  -1.61086807475180E-08  -2.51585624361155E-18
      1.22412808016913E-06
      0.00000000000000E+00  -1.64977946103764E-11   0.00000000000000E+00   2.23554400055907E-13   9.84023632331354E-23
      1.64978320055386E-08   1.64980555599388E-08  -7.10544649997186E-19  -2.98153153992570E-01  -2.98153153992522E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.83062002109490E-11   0.00000000000000E+00  -4.83062002109490E-11
      3.00785563592565E-18  -8.37360105957338E-02  -7.85533700922448E-02   0.00000000000000E+00  -6.43759283922259E-14
     -7.64042206835235E-23  -1.64496849837994E-08  -1.64497493597279E-08  -2.29731098592847E-18
      1.22912808016913E-06
      0.00000000000000E+00  -1.42134323065508E-11   0.00000000000000E+00  -2.24596124067837E-14   4.89000776777389E-23
      1.42135153156398E-08   1.42134928560274E-08  -6.87859714441521E-19  -3.11972278171357E-01  -3.11972278171313E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.40925998856073E-11   0.00000000000000E+00  -4.40925998856073E-11
      2.78739263649762E-18  -4.11232747808650E-02  -3.66589957671358E-02   0.00000000000000E+00   1.22742545593921E-13
     -4.68908957357129E-23  -1.41695229986874E-08  -1.41694002561418E-08  -2.09953292205610E-18
      1.23412808016913E-06
      0.00000000000000E+00  -1.01031966270396E-11   0.00000000000000E+00  -4.03979608648940E-14   2.17499624487786E-23
      1.01032420537724E-08   1.01032016558115E-08  -6.62414931878014E-19  -3.25179765897536E-01  -3.25179765897505E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.14835406823742E-11   0.00000000000000E+00  -3.14835406823742E-11
      2.62997493308575E-18  -1.99375369131704E-02  -1.67642848039405E-02   0.00000000000000E+00   9.04867978201349E-14
     -2.17599625872473E-23  -1.00718086019270E-08  -1.00717181151292E-08  -1.96756000120773E-18
      1.23912808016913E-06
      0.00000000000000E+00  -7.56874110379786E-12   0.00000000000000E+00  -2.48398672104224E-14   1.14994885568957E-23
      7.56875475124050E-09   7.56872991137330E-09  -6.35058646260944E-19  -3.37787670890549E-01  -3.37787670890526E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.21999426029414E-11   0.00000000000000E+00  -2.21999426029414E-11
      2.51897522007104E-18  -1.17149751896700E-02  -9.33731951140732E-03   0.00000000000000E+00   5.20301155281534E-14
     -1.21459190685909E-23  -7.54658199888588E-09  -7.54652996877036E-09  -1.88391657381010E-18
      1.24412808016913E-06
      0.00000000000000E+00  -6.58471658935642E-12   0.00000000000000E+00  -3.15881501095108E-15   7.57162765501587E-24
      6.58474981340616E-09   6.58474665459115E-09  -6.07460514725436E-19  -3.49797419588517E-01  -3.49797419588499E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.80887859552503E-11   0.00000000000000E+00  -1.80887859552503E-11
      2.42853129029479E-18  -8.51761282211649E-03  -6.44868150122408E-03   0.00000000000000E+00   2.17196141188183E-14
     -8.55258399685021E-24  -6.56667958825001E-09  -6.56665786863590E-09  -1.82107077556935E-18
      1.24912808016913E-06
      0.00000000000000E+00  -6.25903515121853E-12   0.00000000000000E+00  -3.07642461571995E-15   5.71008487831611E-24
      6.25907788149200E-09   6.25907480506739E-09  -5.80382731959487E-19  -3.61220340391055E-01  -3.61220340391038E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.63222833376508E-11   0.00000000000000E+00  -1.63222833376508E-11
      2.34691987360654E-18  -7.00052048461125E-03  -5.03363715792562E-03   0.00000000000000E+00   1.83118559286516E-14
     -6.77200570699843E-24  -6.24277083358566E-09  -6.24275252172974E-09  -1.76653714164705E-18
      1.25412808016913E-06
      0.00000000000000E+00  -6.14459660865795E-12   0.00000000000000E+00  -1.00618665866916E-15   4.59426567756440E-24
      6.14461142734806E-09   6.14461042116140E-09  -5.54156829969137E-19  -3.72064377750947E-01  -3.72064377750932E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53567782718772E-11   0.00000000000000E+00  -1.53567782718772E-11
      2.27013598224715E-18  -6.08912104454285E-03  -4.15799601501623E-03   0.00000000000000E+00   1.41623976020120E-14
     -5.63056527369584E-24  -6.12926780528713E-09  -6.12925364288953E-09  -1.71597915227801E-18
      1.25912808016913E-06
      0.00000000000000E+00  -6.09297986634732E-12   0.00000000000000E+00  -3.98424412833917E-16   3.83536140289604E-24
      6.09301648149845E-09   6.09301608307404E-09  -5.29040780178913E-19  -3.82308903568273E-01  -3.82308903568258E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46277927249215E-11   0.00000000000000E+00  -1.46277927249215E-11
      2.19699701862254E-18  -5.45930584259293E-03  -3.54420556467702E-03   0.00000000000000E+00   1.19463361233093E-14
     -4.80896306464803E-24  -6.07840023668524E-09  -6.07838829034912E-09  -1.66795623844363E-18
      1.26412808016913E-06
      0.00000000000000E+00  -6.06212003464560E-12   0.00000000000000E+00  -2.06081994752902E-16   3.29240058331001E-24
      6.06216265113580E-09   6.06216244505381E-09  -5.05441047983842E-19  -3.91850143804967E-01  -3.91850143804953E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.38413992544565E-11   0.00000000000000E+00  -1.38413992544565E-11
      2.12779002235026E-18  -4.99994072596090E-03  -3.09431257402837E-03   0.00000000000000E+00   1.02887402435691E-14
     -4.19519291672119E-24  -6.04833133453958E-09  -6.04832104579934E-09  -1.62234897436642E-18
      1.26912808016913E-06
      0.00000000000000E+00  -6.03934253981813E-12   0.00000000000000E+00  -1.34985234923246E-16   2.89955770813491E-24
      6.03937175410229E-09   6.03937161911706E-09  -4.84145854776554E-19  -4.00416154827806E-01  -4.00416154827793E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.26652771986753E-11   0.00000000000000E+00  -1.26652771986753E-11
      2.06446363635688E-18  -4.66327663827064E-03  -2.76445766626160E-03   0.00000000000000E+00   8.67850969968971E-15
     -3.74255538647237E-24  -6.02671502042808E-09  -6.02670634191838E-09  -1.58031778158033E-18
      1.27412808016913E-06
      0.00000000000000E+00  -6.01950407658130E-12   0.00000000000000E+00  -1.29090586561753E-16   2.62219996295294E-24
      6.01950550463726E-09   6.01950537554668E-09  -4.66487738399022E-19  -4.07503248493355E-01  -4.07503248493344E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06786187872443E-11   0.00000000000000E+00  -1.06786187872443E-11
      2.01107054242066E-18  -4.42599301787568E-03  -2.53280660322550E-03   0.00000000000000E+00   6.85258160172551E-15
     -3.43062610699805E-24  -6.00883360934102E-09  -6.00882675675942E-09  -1.54458280402164E-18
      1.27912808016913E-06
      0.00000000000000E+00  -5.99939007913285E-12   0.00000000000000E+00  -1.53805559603867E-16   2.44310377582346E-24
      5.99941496244896E-09   5.99941480864340E-09  -4.54416435109897E-19  -4.12345695878998E-01  -4.12345695878991E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.41205639660160E-12   0.00000000000000E+00  -7.41205639660160E-12
      1.97401026043765E-18  -4.27849809731118E-03  -2.39061191364411E-03   0.00000000000000E+00   4.56570086436570E-15
     -3.25629519506456E-24  -5.99200731794766E-09  -5.99200275224679E-09  -1.51959382532776E-18
      1.28412808016913E-06
      0.00000000000000E+00  -5.97624520535656E-12   0.00000000000000E+00  -2.14469860418347E-16   2.35788806734854E-24
      5.97621391065363E-09   5.97621369618377E-09  -4.50472040989309E-19  -4.13928086262110E-01  -4.13928086262107E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44905503924926E-12   0.00000000000000E+00  -2.44905503924926E-12
      1.96176498524141E-18  -4.22335357777977E-03  -2.34121348042974E-03   0.00000000000000E+00   1.59507512681525E-15
     -3.23714157889618E-24  -5.97376623621965E-09  -5.97376464114452E-09  -1.51129294425210E-18
      1.28912808016913E-06
      0.00000000000000E+00  -5.94612013155249E-12   0.00000000000000E+00  -3.22867168384387E-16   2.37582886849131E-24
      5.94608589646344E-09   5.94608557359627E-09  -4.57620132512680E-19  -4.11060184482412E-01  -4.11060184482416E-01
      0.00000000000000E+00   0.00000000000000E+00   4.40313669847887E-12   0.00000000000000E+00   4.40313669847887E-12
      1.98378066873380E-18  -4.28017689284547E-03  -2.40537055085850E-03   0.00000000000000E+00  -2.32095887515265E-15
     -3.42767635489983E-24  -5.95048638933587E-09  -5.95048871029475E-09  -1.52616053622112E-18
      1.29412808016913E-06
      0.00000000000000E+00  -5.90212650243008E-12   0.00000000000000E+00  -5.13128091291041E-16   2.52629048189009E-24
      5.90208284066745E-09   5.90208232753936E-09  -4.78913111476588E-19  -4.02518226898417E-01  -4.02518226898430E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29315386811657E-11   0.00000000000000E+00   1.29315386811657E-11
      2.04843836213963E-18  -4.50151964732281E-03  -2.63789109996357E-03   0.00000000000000E+00  -7.52804462450710E-15
     -3.96512294015418E-24  -5.91500633817590E-09  -5.91501386622053E-09  -1.56952525066304E-18
      1.29912808016913E-06
      0.00000000000000E+00  -5.82800779950361E-12   0.00000000000000E+00  -8.81870028834675E-16   2.87374428236296E-24
      5.82798297985896E-09   5.82798209798893E-09  -5.17010697476359E-19  -3.87190127000887E-01  -3.87190127000910E-01
      0.00000000000000E+00   0.00000000000000E+00   2.25240506703137E-11   0.00000000000000E+00   2.25240506703137E-11
      2.16105861549120E-18  -5.01727069687833E-03  -3.17396800325255E-03   0.00000000000000E+00  -1.45721520793117E-14
     -5.20297326245563E-24  -5.85049157650716E-09  -5.85050614865924E-09  -1.64404791801484E-18
      1.30412808016913E-06
      0.00000000000000E+00  -5.68041330681111E-12   0.00000000000000E+00  -3.02066435296494E-15   3.54235440802741E-24
      5.68040382432866E-09   5.68040080366431E-09  -5.73416334220896E-19  -3.64174658739078E-01  -3.64174658739111E-01
      0.00000000000000E+00   0.00000000000000E+00   3.25481122361510E-11   0.00000000000000E+00   3.25481122361510E-11
      2.32379917667195E-18  -6.15994462958406E-03  -4.35998388484319E-03   0.00000000000000E+00  -2.30268066145664E-14
     -8.10730300229148E-24  -5.71292588909384E-09  -5.71294891590046E-09  -1.75038284245106E-18
      1.30912808016913E-06
      0.00000000000000E+00  -5.34187360546417E-12   0.00000000000000E+00  -3.71953890556583E-15   4.71388480017183E-24
      5.34186287682125E-09   5.34185915728235E-09  -6.47168952975223E-19  -3.32847410299983E-01  -3.32847410300027E-01
      0.00000000000000E+00   0.00000000000000E+00   4.33453389817678E-11   0.00000000000000E+00   4.33453389817678E-11
      2.54052587158079E-18  -8.80188137241691E-03  -7.10518628203202E-03   0.00000000000000E+00  -3.80912753018587E-14
     -1.52739018360111E-23  -5.38516640498880E-09  -5.38520449626412E-09  -1.89335691860557E-18
      1.31412808016913E-06
      0.00000000000000E+00  -4.55412129443521E-12   0.00000000000000E+00  -7.46629286701853E-15   6.33485499470901E-24
      4.55415464134505E-09   4.55414717505219E-09  -7.33898381874209E-19  -2.92973149301671E-01  -2.92973149301728E-01
      0.00000000000000E+00   0.00000000000000E+00   5.72037142299923E-11   0.00000000000000E+00   5.72037142299923E-11
      2.82654444273075E-18  -1.49876644727702E-02  -1.35347896821299E-02   0.00000000000000E+00  -5.82665784372803E-14
     -3.17824653034893E-23  -4.61129262270371E-09  -4.61135088928218E-09  -2.09264606085655E-18
      1.31912808016913E-06
      0.00000000000000E+00  -3.08947327018679E-12   0.00000000000000E+00  -1.51681893914974E-14   6.41849563681171E-24
      3.08949073249902E-09   3.08947556430964E-09  -8.28785011765518E-19  -2.45044312351969E-01  -2.45044312352043E-01
      0.00000000000000E+00   0.00000000000000E+00   7.45613288366793E-11   0.00000000000000E+00   7.45613288366793E-11
      3.19935108691415E-18  -2.77420750491645E-02  -2.67452029781544E-02   0.00000000000000E+00  -8.62519666371088E-14
     -5.85579036484857E-23  -3.16395064117962E-09  -3.16403689314632E-09  -2.37056607514863E-18
      1.32412808016913E-06
      0.00000000000000E+00  -1.46767890057628E-12   0.00000000000000E+00  -1.68950728746506E-14  -9.09659366872008E-25
      1.46769181412451E-09   1.46767491905164E-09  -9.31560642711325E-19  -1.90924994172911E-01  -1.90924994172998E-01
      0.00000000000000E+00   0.00000000000000E+00   8.69575897962111E-11   0.00000000000000E+00   8.69575897962111E-11
      3.63413903589521E-18  -4.75186359997257E-02  -4.70288317034757E-02   0.00000000000000E+00  -1.32610648264789E-13
     -8.06139537966935E-23  -1.55449989819950E-09  -1.55463250884785E-09  -2.70257839318388E-18
      1.32912808016913E-06
      0.00000000000000E+00  -5.00094594094983E-13   0.00000000000000E+00  -1.04170439653026E-14  -1.61847697857061E-23
      5.00101781691711E-10   5.00091364647730E-10  -1.04411093126676E-18  -1.33665645410503E-01  -1.33665645410590E-01
      0.00000000000000E+00   0.00000000000000E+00   8.75176143156005E-11   0.00000000000000E+00   8.75176143156005E-11
      4.07172710747321E-18  -7.09334213575190E-02  -7.07482902701923E-02   0.00000000000000E+00  -1.98232804518029E-13
     -9.03169032785393E-23  -5.87410746158722E-10  -5.87608978963331E-10  -3.02761617620645E-18
      1.33412808016913E-06
      0.00000000000000E+00  -1.35470987381102E-13   0.00000000000000E+00  -4.82672643759572E-15  -3.02253413283336E-23
      1.35537406848470E-10   1.35532580122002E-10  -1.16005890848341E-18  -7.82750349240414E-02  -7.82750349241187E-02
      0.00000000000000E+00   0.00000000000000E+00   7.72673488509194E-11   0.00000000000000E+00   7.72673488509194E-11
      4.45806385172780E-18  -9.50025371469813E-02  -9.49354933042104E-02   0.00000000000000E+00  -2.71258093449576E-13
     -9.64142168746265E-23  -2.12528670879375E-10  -2.12799928972921E-10  -3.29800494324440E-18
      1.33912808016913E-06
      0.00000000000000E+00  -4.69326607130462E-14   0.00000000000000E+00  -1.95566863624371E-15  -3.51016160734903E-23
      4.69188934509074E-11   4.69169377822361E-11  -1.24798958003938E-18  -3.79360371136475E-02  -3.79360371137028E-02
      0.00000000000000E+00   0.00000000000000E+00   5.53533534500644E-11   0.00000000000000E+00   5.53533534500644E-11
      4.73483061897813E-18  -1.18439345087058E-01  -1.18407124419504E-01   0.00000000000000E+00  -2.81893560904572E-13
     -1.01806875057969E-22  -1.01988397671294E-10  -1.02270291232301E-10  -3.48684103893875E-18
      1.34412808016913E-06
      0.00000000000000E+00  -3.71971185690483E-14   0.00000000000000E+00  -5.83258852746310E-16  -3.11379628228471E-23
      3.72426326379831E-11   3.72420493790992E-11  -1.29159240729532E-18  -1.86345039233646E-02  -1.86345039233965E-02
      0.00000000000000E+00   0.00000000000000E+00   3.18745307978894E-11   0.00000000000000E+00   3.18745307978894E-11
      4.89420327296758E-18  -1.40904836649736E-01  -1.40883061365031E-01   0.00000000000000E+00  -2.14616238712308E-13
     -1.05471453739148E-22  -6.89019639381707E-11  -6.91165801769885E-11  -3.60261086567226E-18
      1.34912808016913E-06
      0.00000000000000E+00  -4.06872185829343E-14   0.00000000000000E+00  -1.01993596710569E-16  -1.88096784593792E-23
      4.06822135249941E-11   4.06821115313786E-11  -1.30847574713786E-18  -1.12268489599142E-02  -1.12268489599323E-02
      0.00000000000000E+00   0.00000000000000E+00   1.81521580032106E-11   0.00000000000000E+00   1.81521580032106E-11
      4.98496406298363E-18  -1.62335741466960E-01  -1.62317205800299E-01   0.00000000000000E+00  -1.64227010328788E-13
     -1.08037823702370E-22  -5.86700425241523E-11  -5.88342695345892E-11  -3.67648831584577E-18
      1.35412808016913E-06
      0.00000000000000E+00  -4.46365422828580E-14   0.00000000000000E+00   1.48561429763885E-17   1.32457536593680E-24
      4.46665982673975E-11   4.46666131235418E-11  -1.31433711799664E-18  -8.30707050912147E-03  -8.30707050913338E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19109519534921E-11   0.00000000000000E+00   1.19109519534921E-11
      5.04451882275109E-18  -1.82743868098823E-01  -1.82726043535618E-01   0.00000000000000E+00  -1.44441725819842E-13
     -1.10160222213380E-22  -5.64331233511039E-11  -5.65775650770339E-11  -3.73018170475445E-18
      1.35912808016913E-06
      0.00000000000000E+00  -4.79429528223290E-14   0.00000000000000E+00   3.22780143305383E-17   2.40818612559220E-23
      4.79355662398165E-11   4.79355985178549E-11  -1.31622226681630E-18  -6.88409742702397E-03  -6.88409742703310E-03
      0.00000000000000E+00   0.00000000000000E+00   9.13343657012190E-12   0.00000000000000E+00   9.13343657012190E-12
      5.09018600560170E-18  -2.02166844489085E-01  -2.02148865206265E-01   0.00000000000000E+00  -1.37160231058230E-13
     -1.12075946956180E-22  -5.69318748568066E-11  -5.70690350879770E-11  -3.77396373878540E-18
      1.36412808016913E-06
      0.00000000000000E+00  -5.07901396757623E-14   0.00000000000000E+00   3.28792857073895E-17   4.39327008461237E-23
      5.07966087753625E-11   5.07966416546921E-11  -1.31664863625212E-18  -6.01185407651521E-03  -6.01185407652296E-03
      0.00000000000000E+00   0.00000000000000E+00   7.75442872448958E-12   0.00000000000000E+00   7.75442872448958E-12
      5.12895814922415E-18  -2.20649471793188E-01  -2.20631025715523E-01   0.00000000000000E+00  -1.32721041009467E-13
     -1.13849125365713E-22  -5.84183493380584E-11  -5.85510703791817E-11  -3.81230951297203E-18
      1.36912808016913E-06
      0.00000000000000E+00  -5.35454817919881E-14   0.00000000000000E+00   3.35401285656490E-17   5.87879740834835E-23
      5.35341168320131E-11   5.35341503722004E-11  -1.31645595109251E-18  -5.40366861609746E-03  -5.40366861610441E-03
      0.00000000000000E+00   0.00000000000000E+00   6.94829538208102E-12   0.00000000000000E+00   6.94829538208102E-12
      5.16369962613455E-18  -2.38236423705392E-01  -2.38217369274715E-01   0.00000000000000E+00  -1.28458965478445E-13
     -1.15504252545575E-22  -6.03539867886874E-11  -6.04824457542814E-11  -3.84724367504204E-18
      1.37412808016913E-06
      0.00000000000000E+00  -5.63008239082139E-14   0.00000000000000E+00   3.54123503366070E-17   6.89705934822349E-23
      5.62770997159621E-11   5.62771351283814E-11  -1.31593829265651E-18  -4.95898452310242E-03  -4.95898452310882E-03
      0.00000000000000E+00   0.00000000000000E+00   6.39611051105777E-12   0.00000000000000E+00   6.39611051105777E-12
      5.19568017868984E-18  -2.54968253091053E-01  -2.54948508583129E-01   0.00000000000000E+00  -1.24038196490386E-13
     -1.17059907853528E-22  -6.25492074428317E-11  -6.26732456394392E-11  -3.87974188603333E-18
      1.37912808016913E-06
      0.00000000000000E+00  -5.90561660244397E-14   0.00000000000000E+00   3.77066252392425E-17   7.58056136289263E-23
      5.90669425796109E-11   5.90669802863119E-11  -1.31521156595393E-18  -4.63367737418220E-03  -4.63367737418816E-03
      0.00000000000000E+00   0.00000000000000E+00   5.96400144204347E-12   0.00000000000000E+00   5.96400144204347E-12
      5.22550018590006E-18  -2.70878917985242E-01  -2.70858430813940E-01   0.00000000000000E+00  -1.19564554045007E-13
     -1.18530760722763E-22  -6.49114171741920E-11  -6.50309817283555E-11  -3.91028861994614E-18
      1.38412808016913E-06
      0.00000000000000E+00  -6.19033528778730E-14   0.00000000000000E+00   4.00703592839669E-17   8.05639604885608E-23
      6.19156851557035E-11   6.19157252261433E-11  -1.31432489526602E-18  -4.40616259227070E-03  -4.40616259227629E-03
      0.00000000000000E+00   0.00000000000000E+00   5.59251779980188E-12   0.00000000000000E+00   5.59251779980188E-12
      5.25346277489907E-18  -2.86005483848263E-01  -2.85984216363267E-01   0.00000000000000E+00  -1.15209566309478E-13
     -1.19927441848370E-22  -6.73930334595157E-11  -6.75082430259451E-11  -3.93913787963305E-18
      1.38912808016913E-06
      0.00000000000000E+00  -6.48423844685139E-14   0.00000000000000E+00   4.26207866323091E-17   8.41323735048312E-23
      6.48366896391833E-11   6.48367322600541E-11  -1.31329336433123E-18  -4.26810374618296E-03  -4.26810374618821E-03
      0.00000000000000E+00   0.00000000000000E+00   5.25388608079651E-12   0.00000000000000E+00   5.25388608079651E-12
      5.27973220530305E-18  -3.00393977223972E-01  -3.00371896314538E-01   0.00000000000000E+00  -1.11113438535142E-13
     -1.21258127999761E-22  -6.99795049021946E-11  -7.00906183408510E-11  -3.96643884097182E-18
      1.39412808016913E-06
      0.00000000000000E+00  -6.78732607963623E-14   0.00000000000000E+00   4.58661500416528E-17   8.70574712264591E-23
      6.78653575670498E-11   6.78654034332869E-11  -1.31210193506624E-18  -4.22351119796265E-03  -4.22351119796758E-03
      0.00000000000000E+00   0.00000000000000E+00   4.93642087848411E-12   0.00000000000000E+00   4.93642087848411E-12
      5.30441430969547E-18  -3.14112442268693E-01  -3.14089507352430E-01   0.00000000000000E+00  -1.07453332046834E-13
     -1.22530820248081E-22  -7.26943709796014E-11  -7.28018243117707E-11  -3.99231237462923E-18
      1.39912808016913E-06
      0.00000000000000E+00  -7.10878265986257E-14   0.00000000000000E+00   5.07434706411512E-17   8.96705255738494E-23
      7.10761313958594E-11   7.10761821394197E-11  -1.31069456499415E-18  -4.29445464567346E-03  -4.29445464567808E-03
      0.00000000000000E+00   0.00000000000000E+00   4.62021447563602E-12   0.00000000000000E+00   4.62021447563602E-12
      5.32751538207365E-18  -3.27224794144505E-01  -3.27200947459100E-01   0.00000000000000E+00  -1.04079642689520E-13
     -1.23750514971490E-22  -7.55923169722426E-11  -7.56963966150559E-11  -4.01682081707950E-18
      1.40412808016913E-06
      0.00000000000000E+00  -7.45779266125117E-14   0.00000000000000E+00   5.91540642082821E-17   9.22025634404328E-23
      7.46209839105749E-11   7.46210430647314E-11  -1.30893757335480E-18  -4.53879017547186E-03  -4.53879017547611E-03
      0.00000000000000E+00   0.00000000000000E+00   4.25484566059332E-12   0.00000000000000E+00   4.25484566059332E-12
      5.34878961037661E-18  -3.39737166452970E-01  -3.39712318244934E-01   0.00000000000000E+00  -1.00148073337891E-13
     -1.24911902867530E-22  -7.87757406518616E-11  -7.88758887253244E-11  -4.03985203702182E-18
      1.40912808016913E-06
      0.00000000000000E+00  -7.88946292612655E-14   0.00000000000000E+00   7.63340886961643E-17   9.49351775351348E-23
      7.88843857098191E-11   7.88844620440028E-11  -1.30650106171688E-18  -5.09968531980947E-03  -5.09968531981324E-03
      0.00000000000000E+00   0.00000000000000E+00   3.76780448915642E-12   0.00000000000000E+00   3.76780448915642E-12
      5.36762863282240E-18  -3.51652722984390E-01  -3.51626685223290E-01   0.00000000000000E+00  -9.48224973239424E-14
     -1.26000170958606E-22  -8.25574440357096E-11  -8.26522665331595E-11  -4.06112757110552E-18
      1.41412808016913E-06
      0.00000000000000E+00  -8.49563819169622E-14   0.00000000000000E+00   1.18554830356306E-16   9.84545336938404E-23
      8.49158914236567E-11   8.49160099785855E-11  -1.30253374816546E-18  -6.34545477289189E-03  -6.34545477289486E-03
      0.00000000000000E+00   0.00000000000000E+00   2.97507889557558E-12   0.00000000000000E+00   2.97507889557558E-12
      5.38250402730028E-18  -3.62983413607785E-01  -3.62955725591799E-01   0.00000000000000E+00  -8.59858621899087E-14
     -1.26976607362064E-22  -8.78051030118438E-11  -8.78910888741607E-11  -4.07997027913482E-18
      1.41912808016913E-06
      0.00000000000000E+00  -9.57940609074504E-14   0.00000000000000E+00   2.19604073051718E-16   1.04229634894771E-22
      9.57701932601563E-11   9.57704128643335E-11  -1.29479597517410E-18  -9.23970576674294E-03  -9.23970576674431E-03
      0.00000000000000E+00   0.00000000000000E+00   1.37549442845394E-12   0.00000000000000E+00   1.37549442845394E-12
      5.38938149944255E-18  -3.73734777910632E-01  -3.73704174506162E-01   0.00000000000000E+00  -6.77132875592803E-14
     -1.27736159083950E-22  -9.70781940051009E-11  -9.71459072927879E-11  -4.09458552426845E-18
      1.42412808016913E-06
      0.00000000000000E+00  -1.20224761004653E-13   0.00000000000000E+00   4.78567908725941E-16   1.15387193775022E-22
      1.20240250308676E-10   1.20240728876700E-10  -1.27808408313031E-18  -1.59806327625151E-02  -1.59806327625130E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.11815428680426E-12   0.00000000000000E+00  -2.11815428680426E-12
      5.37879072800853E-18  -3.83877709576253E-01  -3.83840498115784E-01   0.00000000000000E+00  -2.78915799971536E-14
     -1.28037946639280E-22  -1.18094683009770E-10  -1.18122574589895E-10  -4.10070664487822E-18
      1.42912808016913E-06
      0.00000000000000E+00  -1.79923840189545E-13   0.00000000000000E+00   1.03172237643007E-15   1.34633829135247E-22
      1.79912834510461E-10   1.79913866232972E-10  -1.24495578426089E-18  -2.95471064672805E-02  -2.95471064672721E-02
      0.00000000000000E+00   0.00000000000000E+00  -8.43580468527834E-12   0.00000000000000E+00  -8.43580468527834E-12
      5.33661170458214E-18  -3.93287492715838E-01  -3.93233473021695E-01   0.00000000000000E+00   3.92481132701467E-14
     -1.27575209625337E-22  -1.71517309660835E-10  -1.71478061547693E-10  -4.09165592032124E-18
      1.43412808016913E-06
      0.00000000000000E+00  -3.12272106505591E-13   0.00000000000000E+00   1.91006148236805E-15   1.56774677465147E-22
      3.12326787896628E-10   3.12328697958268E-10  -1.19479174467949E-18  -4.98959151444858E-02  -4.98959151444702E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.55452869486036E-11   0.00000000000000E+00  -1.55452869486036E-11
      5.25888526983912E-18  -4.01658570074389E-01  -4.01565075858678E-01   0.00000000000000E+00   1.00075481729884E-13
     -1.26413813723386E-22  -2.96883486491267E-10  -2.96783411009664E-10  -4.06409352515963E-18
      1.43912808016913E-06
      0.00000000000000E+00  -5.68151544365760E-13   0.00000000000000E+00   3.14802714829569E-15   1.74167696448920E-22
      5.68136484075603E-10   5.68139632102926E-10  -1.13670180592664E-18  -7.34888344541064E-02  -7.34888344540859E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.05150277730963E-11   0.00000000000000E+00  -2.05150277730963E-11
      5.15631013097364E-18  -4.08446821446940E-01  -4.08274304964851E-01   0.00000000000000E+00   1.24787869831359E-13
     -1.24951527568213E-22  -5.47749392199536E-10  -5.47624604329829E-10  -4.01960832504699E-18
      1.44412808016913E-06
      0.00000000000000E+00  -1.00891443822468E-12   0.00000000000000E+00   4.91891383102581E-15   1.86719572807415E-22
      1.00889407519248E-09   1.00889899410649E-09  -1.07942180597101E-18  -9.75276036640608E-02  -9.75276036640372E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.36383800550630E-11   0.00000000000000E+00  -2.36383800550630E-11
      5.03811823069832E-18  -4.12844565101321E-01  -4.12534179605775E-01   0.00000000000000E+00   1.29929592602711E-13
     -1.23397910176283E-22  -9.85390543643910E-10  -9.85260614051431E-10  -3.95869642472731E-18
      1.44912808016913E-06
      0.00000000000000E+00  -1.69536200411374E-12   0.00000000000000E+00   7.27328901287848E-15   1.96458266840881E-22
      1.69533146745348E-09   1.69533874074269E-09  -1.02704056488070E-18  -1.20869220049892E-01  -1.20869220049865E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.62563072565881E-11   0.00000000000000E+00  -2.62563072565881E-11
      4.90683669441538E-18  -4.13801642104421E-01  -4.13275829762807E-01   0.00000000000000E+00   1.34643074187255E-13
     -1.21745268241701E-22  -1.66921707656017E-09  -1.66908243348610E-09  -3.87979612953468E-18
      1.45412808016913E-06
      0.00000000000000E+00  -2.67148787115533E-12   0.00000000000000E+00   1.00665720484932E-14   2.03970801825635E-22
      2.67150747384763E-09   2.67151754041989E-09  -9.80294843281435E-19  -1.43226023975175E-01  -1.43226023975146E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.90413924786703E-11   0.00000000000000E+00  -2.90413924786703E-11
      4.76162973202203E-18  -4.10111958990596E-01  -4.09279492121296E-01   0.00000000000000E+00   1.46964934181434E-13
     -1.19889506294819E-22  -2.64262311287528E-09  -2.64247614794122E-09  -3.78133488874059E-18
      1.45912808016913E-06
      0.00000000000000E+00  -3.95097690519339E-12   0.00000000000000E+00   1.30019982822244E-14   2.08733232715627E-22
      3.95096209542261E-09   3.95097509742110E-09  -9.38597944348523E-19  -1.64547242136455E-01  -1.64547242136423E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19298144833850E-11   0.00000000000000E+00  -3.19298144833850E-11
      4.60198065960511E-18  -4.00560722124474E-01  -3.99326084647087E-01   0.00000000000000E+00   1.68944544718068E-13
     -1.17693511805896E-22  -3.91921422748231E-09  -3.91904528293771E-09  -3.66338271525658E-18
      1.46412808016913E-06
      0.00000000000000E+00  -5.51738889826775E-12   0.00000000000000E+00   1.57529102523374E-14   2.10088201497055E-22
      5.51740137138685E-09   5.51741712429732E-09  -9.01027072384710E-19  -1.84848923011446E-01  -1.84848923011411E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.46267803982585E-11   0.00000000000000E+00  -3.46267803982585E-11
      4.42884675761381E-18  -3.84064062663444E-01  -3.82336774884009E-01   0.00000000000000E+00   2.00447664909436E-13
     -1.15005530731693E-22  -5.48299079156385E-09  -5.48279034389905E-09  -3.52781968522910E-18
      1.46912808016913E-06
      0.00000000000000E+00  -7.33416964496984E-12   0.00000000000000E+00   1.82184182171269E-14   2.07850587922449E-22
      7.33414563173547E-09   7.33416385015390E-09  -8.66710994095489E-19  -2.04170048196669E-01  -2.04170048196632E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.68803891362387E-11   0.00000000000000E+00  -3.68803891362387E-11
      4.24444481193262E-18  -3.59760509508733E-01  -3.57461562728562E-01   0.00000000000000E+00   2.38895334591656E-13
     -1.11672841385253E-22  -7.29752235635214E-09  -7.29728346101766E-09  -3.37773381783713E-18
      1.47412808016913E-06
      0.00000000000000E+00  -9.34979424772622E-12   0.00000000000000E+00   2.01511768779316E-14   2.02676214358690E-22
      9.34977456954855E-09   9.34979472072563E-09  -8.34948301028395E-19  -2.22555644411900E-01  -2.22555644411862E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.85850186875437E-11   0.00000000000000E+00  -3.85850186875437E-11
      4.05151971849490E-18  -3.27076946869439E-01  -3.24143492819357E-01   0.00000000000000E+00   2.78216682923374E-13
     -1.07549328469060E-22  -9.31148791872089E-09  -9.31120970203808E-09  -3.21657141746651E-18
      1.47912808016913E-06
      0.00000000000000E+00  -1.14840822509547E-11   0.00000000000000E+00   2.12990463169015E-14   1.95725298708446E-22
      1.14841028981578E-08   1.14841241972043E-08  -8.05244067783897E-19  -2.40050125984859E-01  -2.40050125984819E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.98979390129273E-11   0.00000000000000E+00  -3.98979390129273E-11
      3.85203002343026E-18  -2.85861880809334E-01  -2.82256378258620E-01   0.00000000000000E+00   3.05433098351925E-13
     -1.02475335173780E-22  -1.14445316912896E-08  -1.14442262581914E-08  -3.04678595564637E-18
      1.48412808016913E-06
      0.00000000000000E+00  -1.35669372013470E-11   0.00000000000000E+00   2.07711234496989E-14   1.86134728654166E-22
      1.35669317892857E-08   1.35669525604093E-08  -7.77379387217125E-19  -2.56693387861641E-01  -2.56693387861599E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.14972820707247E-11   0.00000000000000E+00  -4.14972820707247E-11
      3.64454361307664E-18  -2.36781391782322E-01  -2.32520135973299E-01   0.00000000000000E+00   3.00425572541131E-13
     -9.63318483753759E-23  -1.35257557039110E-08  -1.35254552783386E-08  -2.86716422585951E-18
      1.48912808016913E-06
      0.00000000000000E+00  -1.52803007739534E-11   0.00000000000000E+00   1.71053736998803E-14   1.66895737202391E-22
      1.52802860626883E-08   1.52803031680622E-08  -7.51431961165447E-19  -2.72518942554798E-01  -2.72518942554753E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.44112282775534E-11   0.00000000000000E+00  -4.44112282775534E-11
      3.42248747168887E-18  -1.81943962144771E-01  -1.77143765399841E-01   0.00000000000000E+00   2.52331483139671E-13
     -8.97876344706072E-23  -1.52361442712677E-08  -1.52358919397847E-08  -2.67105551052343E-18
      1.49412808016913E-06
      0.00000000000000E+00  -1.63722428546137E-11   0.00000000000000E+00   3.52641560853619E-13   1.32583266034834E-22
      1.63722524893963E-08   1.63726051309573E-08  -7.27286734452999E-19  -2.87565044732660E-01  -2.87565044732613E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.73520383400421E-11   0.00000000000000E+00  -4.73520383400421E-11
      3.18572727998866E-18  -1.24526050018099E-01  -1.19382700395326E-01   0.00000000000000E+00  -1.53032718875782E-13
     -8.40346770094467E-23  -1.63251000598983E-08  -1.63252530926173E-08  -2.45844054553566E-18
      1.49912808016913E-06
      0.00000000000000E+00  -1.62386087619768E-11   0.00000000000000E+00  -1.06620277031551E-15   8.44210346617802E-23
      1.62386264310138E-08   1.62386253648112E-08  -7.04652862619894E-19  -3.01878479006182E-01  -3.01878479006134E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.81573653524183E-11   0.00000000000000E+00  -4.81573653524183E-11
      2.94494045322657E-18  -7.04252768276404E-02  -6.53242482213787E-02   0.00000000000000E+00   1.46859280556820E-13
     -7.05301522104015E-23  -1.61906148587392E-08  -1.61904679994587E-08  -2.24028759060668E-18
      1.50000000000000E-06
      0.00000000000000E+00  -1.58494626104285E-11   0.00000000000000E+00  -2.18668752936769E-14   7.49714561328661E-23
      1.58494322000035E-08   1.58494103331283E-08  -7.00739881059505E-19  -3.04352105782212E-01  -3.04352105782164E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.86610619899029E-11   0.00000000000000E+00  -4.86610619899029E-11
      2.90251190828644E-18  -6.14052317464314E-02  -5.64269840511000E-02   0.00000000000000E+00   1.42159295947913E-13
     -6.49474461147202E-23  -1.58008914304343E-08  -1.58007492711384E-08  -2.20177202722693E-18
}
